/*
 * Decompiled with CFR 0.152.
 */
package com.wireframesketcher.spy;

import com.wireframesketcher.model.Button;
import com.wireframesketcher.model.Checkbox;
import com.wireframesketcher.model.ColorDesc;
import com.wireframesketcher.model.Combo;
import com.wireframesketcher.model.FontSize;
import com.wireframesketcher.model.FontSupport;
import com.wireframesketcher.model.Group;
import com.wireframesketcher.model.Icon;
import com.wireframesketcher.model.IconDesc;
import com.wireframesketcher.model.IconSize;
import com.wireframesketcher.model.ModelFactory;
import com.wireframesketcher.model.Panel;
import com.wireframesketcher.model.Position;
import com.wireframesketcher.model.RadioButton;
import com.wireframesketcher.model.Screen;
import com.wireframesketcher.model.SearchField;
import com.wireframesketcher.model.SelectionSupport;
import com.wireframesketcher.model.Spinner;
import com.wireframesketcher.model.State;
import com.wireframesketcher.model.StateSupport;
import com.wireframesketcher.model.TabbedPane;
import com.wireframesketcher.model.Table;
import com.wireframesketcher.model.Tabs;
import com.wireframesketcher.model.TextAlignment;
import com.wireframesketcher.model.TextAlignmentSupport;
import com.wireframesketcher.model.TextArea;
import com.wireframesketcher.model.TextField;
import com.wireframesketcher.model.VerticalScrollbarSupport;
import com.wireframesketcher.model.Widget;
import com.wireframesketcher.model.Window;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class Converter {
    private final Shell shell;
    private final ModelFactory factory = ModelFactory.eINSTANCE;
    private final Screen screen;
    private Point origin = new Point(25, 25);

    public Converter(Shell shell) {
        this.shell = shell;
        this.screen = this.factory.createScreen();
        this.screen.getFont().setSize(FontSize.inPixels((int)12));
        this.convert((Control)shell);
    }

    private void convert(Control control) {
        if (control == null) {
            return;
        }
        if (!control.isVisible()) {
            return;
        }
        Point size = control.getSize();
        if (size.x == 0 || size.y == 0) {
            return;
        }
        String methodName = "convert" + control.getClass().getSimpleName();
        Method method = null;
        try {
            method = this.getClass().getMethod(methodName, control.getClass());
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (method != null) {
            try {
                method.invoke((Object)this, control);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        } else if (control instanceof Canvas && size.x > 30 && size.y > 30) {
            Panel panel = this.factory.createPanel();
            Converter.applyScrollbar((VerticalScrollbarSupport)panel, (Scrollable)((Canvas)control));
            this.add((Widget)panel, control);
        }
        if (control instanceof Composite && !this.isWidgetComposite(control)) {
            Composite composite = (Composite)control;
            Control[] children = composite.getChildren();
            for (int i = 0; i < children.length; ++i) {
                this.convert(children[i]);
            }
        }
    }

    private boolean isWidgetComposite(Control control) {
        return control instanceof DateTime;
    }

    private void add(Widget widget, int x, int y, int width, int height) {
        widget.setX(this.origin.x + x);
        widget.setY(this.origin.y + y);
        if ((widget.getDescriptor().getResizeMode().getValue() & 1) != 0 && !(widget instanceof com.wireframesketcher.model.Label) && !(widget instanceof Icon)) {
            widget.setWidth(width);
        }
        if ((widget.getDescriptor().getResizeMode().getValue() & 2) != 0 && !(widget instanceof Icon)) {
            widget.setHeight(height);
        }
        this.screen.getWidgets().add((Object)widget);
    }

    private void add(Widget widget, Control control) {
        this.add(widget, control, 0, 0);
    }

    private void add(Widget widget, Control control, int dx, int dy) {
        Rectangle bounds = control.getBounds();
        int x = bounds.x;
        int y = bounds.y;
        if (control.getParent() != null && !(control instanceof Shell)) {
            Point location = control.getParent().toDisplay(x, y);
            x = location.x;
            y = location.y;
        }
        x -= this.shell.getBounds().x;
        y -= this.shell.getBounds().y;
        this.add(widget, x += dx, y += dy, bounds.width - dx, bounds.height - dy);
    }

    private void add(Widget widget, Composite parent, Rectangle bounds, int dx, int dy) {
        Point location = parent.toDisplay(bounds.x, bounds.y);
        int x = location.x;
        int y = location.y;
        this.add(widget, (x -= this.shell.getBounds().x) + dx, (y -= this.shell.getBounds().y) + dy, bounds.width - dx, bounds.height - dy);
    }

    public void convertShell(Shell control) {
        Window window = this.factory.createWindow();
        window.setText(control.getText());
        int style = control.getStyle();
        window.setCloseButton((style & 0x40) != 0);
        window.setMinimizeButton((style & 0x80) != 0);
        window.setMaximizeButton((style & 0x400) != 0);
        Converter.applyScrollbar((VerticalScrollbarSupport)window, (Scrollable)control);
        this.add((Widget)window, (Control)control);
        if (control.getMenuBar() != null && !"carbon".equals(SWT.getPlatform()) && !"cocoa".equals(SWT.getPlatform())) {
            Menu menuWidget = control.getMenuBar();
            com.wireframesketcher.model.Menu menu = this.factory.createMenu();
            MenuItem[] items = menuWidget.getItems();
            StringBuilder content = new StringBuilder();
            for (int i = 0; i < items.length; ++i) {
                content.append(Action.removeMnemonics((String)items[i].getText()));
                if (i >= items.length - 1) continue;
                content.append(',');
            }
            menu.setText(content.toString());
            Rectangle bounds = control.getBounds();
            this.add((Widget)menu, 0, 19, bounds.width, -1);
        }
    }

    public void convertGroup(org.eclipse.swt.widgets.Group control) {
        Group group = this.factory.createGroup();
        group.setText(Action.removeMnemonics((String)control.getText()));
        this.add((Widget)group, (Control)control);
    }

    public void convertButton(org.eclipse.swt.widgets.Button control) {
        Checkbox widget = null;
        if ((control.getStyle() & 0x20) != 0) {
            Checkbox checkbox = this.factory.createCheckbox();
            checkbox.setSelected(control.getSelection());
            Converter.applyState((StateSupport)checkbox, (Control)control);
            widget = checkbox;
        } else if ((control.getStyle() & 0x10) != 0) {
            RadioButton radioButton = this.factory.createRadioButton();
            radioButton.setSelected(control.getSelection());
            Converter.applyState((StateSupport)radioButton, (Control)control);
            widget = radioButton;
        } else if ((control.getStyle() & 8) != 0) {
            Button button = this.factory.createButton();
            Converter.applyState((StateSupport)button, (Control)control);
            widget = button;
        } else if ((control.getStyle() & 4) != 0) {
            Button button = this.factory.createButton();
            String iconName = (control.getStyle() & 0x80) != 0 ? "empty-arrow-up" : ((control.getStyle() & 0x4000) != 0 ? "empty-arrow-left" : ((control.getStyle() & 0x20000) != 0 ? "empty-arrow-right" : "empty-arrow-down"));
            button.setIcon(new IconDesc(iconName, IconSize.SMALL_LITERAL));
            Converter.applyState((StateSupport)button, (Control)control);
            widget = button;
        }
        if (widget != null) {
            widget.setText(Action.removeMnemonics((String)control.getText()));
        }
        if (widget != null) {
            this.add((Widget)widget, (Control)control);
        }
    }

    public void convertLabel(Label control) {
        if ((control.getStyle() & 2) != 0) {
            this.add((Widget)this.factory.createHLine(), (Control)control);
        } else if (control.getText().trim().length() > 0) {
            if (Converter.isMultiLine((Control)control)) {
                com.wireframesketcher.model.Text text = this.factory.createText();
                text.setText(Action.removeMnemonics((String)control.getText()));
                Converter.applyAlignment((TextAlignmentSupport)text, (Control)control);
                Converter.applyFont((FontSupport)text, (Control)control);
                this.add((Widget)text, (Control)control);
            } else {
                com.wireframesketcher.model.Label label = this.factory.createLabel();
                label.setText(Action.removeMnemonics((String)control.getText()));
                Converter.applyAlignment((TextAlignmentSupport)label, (Control)control);
                Converter.applyFont((FontSupport)label, (Control)control);
                Converter.applyState((StateSupport)label, (Control)control);
                this.add((Widget)label, (Control)control);
            }
        } else if (control.getImage() != null) {
            this.add((Widget)this.factory.createPlaceholder(), (Control)control);
        }
    }

    public void convertCLabel(CLabel control) {
        if (control.getText() != null && control.getText().trim().length() > 0) {
            if (Converter.isMultiLine((Control)control)) {
                com.wireframesketcher.model.Text text = this.factory.createText();
                text.setText(Action.removeMnemonics((String)control.getText()));
                Converter.applyAlignment((TextAlignmentSupport)text, (Control)control);
                Converter.applyFont((FontSupport)text, (Control)control);
                this.add((Widget)text, (Control)control);
            } else {
                com.wireframesketcher.model.Label label = this.factory.createLabel();
                label.setText(Action.removeMnemonics((String)control.getText()));
                Converter.applyAlignment((TextAlignmentSupport)label, (Control)control);
                Converter.applyFont((FontSupport)label, (Control)control);
                Converter.applyState((StateSupport)label, (Control)control);
                this.add((Widget)label, (Control)control);
            }
        } else if (control.getImage() != null) {
            this.add((Widget)this.factory.createPlaceholder(), (Control)control);
        }
    }

    public void convertText(Text control) {
        if ((control.getStyle() & 0x80) != 0) {
            SearchField searchField = this.factory.createSearchField();
            searchField.setText(control.getText());
            this.add((Widget)searchField, (Control)control);
        } else if (Converter.isUsedAsLabel((Control)control)) {
            if (Converter.isMultiLine((Control)control)) {
                com.wireframesketcher.model.Text text = this.factory.createText();
                text.setText(control.getText());
                Converter.applyAlignment((TextAlignmentSupport)text, (Control)control);
                Converter.applyFont((FontSupport)text, (Control)control);
                this.add((Widget)text, (Control)control);
            } else {
                com.wireframesketcher.model.Label label = this.factory.createLabel();
                label.setText(control.getText());
                Converter.applyAlignment((TextAlignmentSupport)label, (Control)control);
                Converter.applyFont((FontSupport)label, (Control)control);
                Converter.applyState((StateSupport)label, (Control)control);
                this.add((Widget)label, (Control)control);
            }
        } else if (Converter.isMultiLine((Control)control)) {
            TextArea textArea = this.factory.createTextArea();
            textArea.setText(control.getText());
            Converter.applyState((StateSupport)textArea, (Control)control);
            Converter.applyScrollbar((VerticalScrollbarSupport)textArea, (Scrollable)control);
            this.add((Widget)textArea, (Control)control);
        } else {
            TextField textField = this.factory.createTextField();
            if ((control.getStyle() & 0x400000) != 0) {
                textField.setText(Converter.createPasswordText(control.getText()));
            } else {
                textField.setText(control.getText());
            }
            Converter.applyState((StateSupport)textField, (Control)control);
            this.add((Widget)textField, (Control)control);
        }
    }

    public void convertCombo(org.eclipse.swt.widgets.Combo control) {
        Combo combo = this.factory.createCombo();
        combo.setText(control.getText());
        Converter.applyState((StateSupport)combo, (Control)control);
        this.add((Widget)combo, (Control)control);
        if ((control.getStyle() & 0x40) != 0) {
            com.wireframesketcher.model.List list = this.factory.createList();
            String[] items = control.getItems();
            StringBuilder content = new StringBuilder();
            for (int i = 0; i < items.length; ++i) {
                content.append(items[i]);
                content.append('\n');
            }
            list.setText(content.toString());
            list.setSelection(control.getSelectionIndex());
            this.add((Widget)list, (Control)control, 0, 22);
            list.setWidth(-1);
            list.setHeight(-1);
        }
    }

    public void convertCCombo(CCombo control) {
        Combo combo = this.factory.createCombo();
        combo.setText(control.getText());
        Converter.applyState((StateSupport)combo, (Control)control);
        this.add((Widget)combo, (Control)control);
    }

    public void convertLink(Link control) {
        if (Converter.isMultiLine((Control)control)) {
            com.wireframesketcher.model.Text link = this.factory.createText();
            link.setText(this.replaceLinkTags(control.getText()));
            this.add((Widget)link, (Control)control);
        } else {
            com.wireframesketcher.model.Label link = this.factory.createLabel();
            link.setText(this.replaceLinkTags(control.getText()));
            Converter.applyState((StateSupport)link, (Control)control);
            this.add((Widget)link, (Control)control);
        }
    }

    public void convertTree(Tree control) {
        TreeColumn[] columns = control.getColumns();
        if (columns.length > 1) {
            Table table = this.factory.createTable();
            StringBuilder content = new StringBuilder();
            if (columns.length > 0) {
                for (int i = 0; i < columns.length; ++i) {
                    content.append(columns[i].getText());
                    if (i >= columns.length - 1) continue;
                    content.append(',');
                }
                content.append('\n');
            }
            TreeItem[] items = control.getItems();
            for (int i = 0; i < items.length; ++i) {
                TreeItem item = items[i];
                if (!this.isItemVisible(item)) continue;
                for (int j = 0; j < columns.length; ++j) {
                    content.append(item.getText(j));
                    if (j >= columns.length - 1) continue;
                    content.append(',');
                }
                content.append('\n');
            }
            table.setText(content.toString());
            Converter.applyScrollbar((VerticalScrollbarSupport)table, (Scrollable)control);
            this.add((Widget)table, (Control)control);
        } else {
            com.wireframesketcher.model.Tree tree = this.factory.createTree();
            TreeItem[] items = control.getItems();
            StringBuilder content = new StringBuilder();
            for (int i = 0; i < items.length; ++i) {
                this.convertTreeItem(items[i], content, 0);
            }
            tree.setText(content.toString());
            Converter.applyScrollbar((VerticalScrollbarSupport)tree, (Scrollable)control);
            this.add((Widget)tree, (Control)control);
        }
    }

    private void convertTreeItem(TreeItem item, StringBuilder content, int indent) {
        String text = item.getText();
        if (text != null && text.length() > 0) {
            for (int i = 0; i < indent; ++i) {
                content.append('-');
            }
            content.append(text);
            content.append('\n');
            TreeItem[] items = item.getItems();
            if (items != null) {
                for (int i = 0; i < items.length; ++i) {
                    this.convertTreeItem(items[i], content, indent + 1);
                }
            }
        }
    }

    public void convertTable(org.eclipse.swt.widgets.Table control) {
        Table table = this.factory.createTable();
        table.setAlternative(ColorDesc.createFromString((String)"#EEEEEE"));
        StringBuilder content = new StringBuilder();
        TableColumn[] columns = control.getColumns();
        if (columns.length > 0) {
            for (int i = 0; i < columns.length; ++i) {
                TableColumn col = columns[i];
                if ((col.getStyle() & 0x1000000) != 0) {
                    content.append("=. ");
                } else if ((col.getStyle() & 0x20000) != 0) {
                    content.append(">. ");
                }
                content.append(col.getText());
                if (i >= columns.length - 1) continue;
                content.append(',');
            }
            content.append('\n');
        }
        boolean checkTable = (control.getStyle() & 0x20) != 0;
        TableItem[] items = control.getItems();
        for (int i = 0; i < items.length; ++i) {
            TableItem item = items[i];
            if (!this.isItemVisible(item)) continue;
            if (checkTable) {
                if (item.getChecked()) {
                    content.append("[x] ");
                } else {
                    content.append("[ ] ");
                }
            }
            if (columns.length > 0) {
                for (int j = 0; j < columns.length; ++j) {
                    content.append(item.getText(j));
                    if (j >= columns.length - 1) continue;
                    content.append(',');
                }
            } else {
                content.append(item.getText());
            }
            content.append('\n');
        }
        table.setText(content.toString());
        if (control.getSelectionIndex() != -1) {
            table.setSelection(control.getSelectionIndex() + 1);
        }
        table.setHeader(control.getHeaderVisible());
        Converter.applyScrollbar((VerticalScrollbarSupport)table, (Scrollable)control);
        this.add((Widget)table, (Control)control);
    }

    public void convertSlider(Slider control) {
        if ((control.getStyle() & 0x200) != 0) {
            this.add((Widget)this.factory.createVScrollbar(), (Control)control);
        } else {
            this.add((Widget)this.factory.createHScrollbar(), (Control)control);
        }
    }

    public void convertTabFolder(TabFolder control) {
        if (control.getItemCount() == 0) {
            return;
        }
        Tabs tabs = null;
        TabItem[] selection = control.getSelection();
        if (selection != null && selection.length > 0 && selection[0].getControl() != null && selection[0].getControl().isVisible()) {
            tabs = this.factory.createTabbedPane();
            if ((control.getStyle() & 0x400) != 0) {
                ((TabbedPane)tabs).setPosition(Position.BOTTOM);
            }
        } else {
            tabs = this.factory.createTabs();
        }
        StringBuilder content = new StringBuilder();
        TabItem[] items = control.getItems();
        for (int i = 0; i < items.length; ++i) {
            content.append(Action.removeMnemonics((String)items[i].getText()));
            if (i >= items.length - 1) continue;
            content.append(',');
        }
        tabs.setText(content.toString());
        ((SelectionSupport)tabs).setSelection(control.getSelectionIndex());
        if (tabs instanceof VerticalScrollbarSupport) {
            Converter.applyScrollbar((VerticalScrollbarSupport)tabs, (Scrollable)control);
        }
        this.add((Widget)tabs, (Control)control);
    }

    public void convertCTabFolder(CTabFolder control) {
        if (control.getItemCount() == 0) {
            return;
        }
        Tabs tabs = null;
        CTabItem selection = control.getSelection();
        if (selection != null && selection.getControl() != null && selection.getControl().isVisible()) {
            tabs = this.factory.createTabbedPane();
            if ((control.getStyle() & 0x400) != 0) {
                ((TabbedPane)tabs).setPosition(Position.BOTTOM);
            }
        } else {
            tabs = this.factory.createTabs();
        }
        StringBuilder content = new StringBuilder();
        CTabItem[] items = control.getItems();
        for (int i = 0; i < items.length; ++i) {
            content.append(Action.removeMnemonics((String)items[i].getText()));
            if (i >= items.length - 1) continue;
            content.append(',');
        }
        tabs.setText(content.toString());
        ((SelectionSupport)tabs).setSelection(control.getSelectionIndex());
        if (tabs instanceof VerticalScrollbarSupport) {
            Converter.applyScrollbar((VerticalScrollbarSupport)tabs, (Scrollable)control);
        }
        this.add((Widget)tabs, (Control)control);
    }

    public void convertToolBar(ToolBar control) {
        ToolItem[] items = control.getItems();
        for (int i = 0; i < items.length; ++i) {
            ToolItem item = items[i];
            if ((item.getStyle() & 2) != 0) {
                if ((control.getStyle() & 0x200) != 0) {
                    this.add((Widget)this.factory.createHLine(), (Composite)control, item.getBounds(), 0, 0);
                    continue;
                }
                this.add((Widget)this.factory.createVLine(), (Composite)control, item.getBounds(), 0, 0);
                continue;
            }
            Icon icon = this.factory.createIcon();
            icon.setIcon(new IconDesc("image", IconSize.SMALL_LITERAL));
            this.add((Widget)icon, (Composite)control, item.getBounds(), 6, 6);
            if ((item.getStyle() & 4) == 0) continue;
            icon = this.factory.createIcon();
            icon.setIcon(new IconDesc("empty-arrow-down", IconSize.SMALL_LITERAL));
            this.add((Widget)icon, (Composite)control, item.getBounds(), 22, 6);
        }
    }

    public void convertCoolBar(CoolBar control) {
        CoolItem[] items = control.getItems();
        for (int i = 0; i < items.length; ++i) {
            CoolItem item = items[i];
            if ((control.getStyle() & 0x200) != 0) {
                this.add((Widget)this.factory.createHLine(), (Composite)control, item.getBounds(), 0, 0);
                continue;
            }
            this.add((Widget)this.factory.createVLine(), (Composite)control, item.getBounds(), 0, 0);
        }
    }

    public void convertSash(Sash control) {
        if ((control.getStyle() & 0x200) != 0) {
            this.add((Widget)this.factory.createVLine(), (Control)control);
        } else {
            this.add((Widget)this.factory.createHLine(), (Control)control);
        }
    }

    public void convertProgressBar(ProgressBar control) {
        this.add((Widget)this.factory.createProgressBar(), (Control)control);
    }

    public void convertComposite(Composite control) {
    }

    public void convertSpinner(org.eclipse.swt.widgets.Spinner control) {
        Spinner spinner = this.factory.createSpinner();
        spinner.setText(Integer.toString(control.getSelection()));
        Converter.applyState((StateSupport)spinner, (Control)control);
        this.add((Widget)spinner, (Control)control);
    }

    public void convertScale(Scale control) {
        if ((control.getStyle() & 0x200) != 0) {
            this.add((Widget)this.factory.createVSlider(), (Control)control);
        } else {
            this.add((Widget)this.factory.createHSlider(), (Control)control);
        }
    }

    public void convertStyledText(StyledText control) {
        if (Converter.isUsedAsLabel((Control)control)) {
            com.wireframesketcher.model.Text text = this.factory.createText();
            text.setText(control.getText());
            Converter.applyAlignment((TextAlignmentSupport)text, (Control)control);
            Converter.applyFont((FontSupport)text, (Control)control);
            this.add((Widget)text, (Control)control);
        } else {
            TextArea textArea = this.factory.createTextArea();
            textArea.setText(control.getText());
            Converter.applyState((StateSupport)textArea, (Control)control);
            Converter.applyScrollbar((VerticalScrollbarSupport)textArea, (Scrollable)control);
            this.add((Widget)textArea, (Control)control);
        }
    }

    public void convertList(List control) {
        com.wireframesketcher.model.List list = this.factory.createList();
        String[] items = control.getItems();
        StringBuilder content = new StringBuilder();
        for (int i = 0; i < items.length; ++i) {
            if (content.length() > 0) {
                content.append('\n');
            }
            content.append(items[i]);
        }
        list.setText(content.toString());
        if (control.getSelectionIndex() != -1) {
            list.setSelection(control.getSelectionIndex());
        }
        Converter.applyScrollbar((VerticalScrollbarSupport)list, (Scrollable)control);
        this.add((Widget)list, (Control)control);
    }

    public void convertDateTime(DateTime control) {
        if ((control.getStyle() & 0x400) == 0) {
            TextField textField = this.factory.createTextField();
            if (control.getChildren().length > 0 && control.getChildren()[0] instanceof Text) {
                textField.setText(((Text)control.getChildren()[0]).getText());
            }
            Converter.applyState((StateSupport)textField, (Control)control);
            this.add((Widget)textField, (Control)control);
        }
    }

    private boolean isItemVisible(TableItem item) {
        Point size = item.getParent().getSize();
        Rectangle itemBounds = item.getBounds();
        return itemBounds.y >= 0 && itemBounds.y < size.y || itemBounds.y + itemBounds.height > 5 && itemBounds.y + itemBounds.height <= size.y;
    }

    private boolean isItemVisible(TreeItem item) {
        Point size = item.getParent().getSize();
        Rectangle itemBounds = item.getBounds();
        return itemBounds.y >= 0 && itemBounds.y < size.y || itemBounds.y + itemBounds.height > 5 && itemBounds.y + itemBounds.height <= size.y;
    }

    private static boolean isMultiLine(Control control) {
        if ((control.getStyle() & 0x100) != 0) {
            return true;
        }
        if ((control.getStyle() & 0x200) != 0) {
            return true;
        }
        if ((control.getStyle() & 2) != 0) {
            return true;
        }
        if (control instanceof Label || control instanceof CLabel || control instanceof Link) {
            int fontHeight = Converter.getFontHeight(control);
            return control.getSize().y >= 2 * fontHeight;
        }
        return false;
    }

    private static int getFontHeight(Control control) {
        GC gc = new GC((Drawable)control);
        try {
            int n = gc.getFontMetrics().getHeight();
            return n;
        }
        finally {
            gc.dispose();
        }
    }

    private static void applyFont(FontSupport widget, Control control) {
        int fontStyle = control.getFont().getFontData()[0].getStyle();
        if ((fontStyle & 1) != 0) {
            widget.getFont().setBold(Boolean.TRUE);
        }
        if ((fontStyle & 2) != 0) {
            widget.getFont().setItalic(Boolean.TRUE);
        }
    }

    private static void applyAlignment(TextAlignmentSupport widget, Control control) {
        if ((control.getStyle() & 0x1000000) != 0) {
            widget.setTextAlignment(TextAlignment.CENTER_LITERAL);
        } else if ((control.getStyle() & 0x4000) != 0) {
            widget.setTextAlignment(TextAlignment.LEFT_LITERAL);
        } else if ((control.getStyle() & 0x20000) != 0) {
            widget.setTextAlignment(TextAlignment.RIGHT_LITERAL);
        }
    }

    private static void applyState(StateSupport widget, Control control) {
        if (widget.isValidState(State.DISABLED) && !control.isEnabled()) {
            widget.setState(State.DISABLED);
        }
    }

    private static void applyScrollbar(VerticalScrollbarSupport widget, Scrollable control) {
        if (control.getVerticalBar() != null && control.getVerticalBar().isVisible()) {
            widget.setVerticalScrollbar(true);
        }
    }

    private static boolean isUsedAsLabel(Control control) {
        return (control.getStyle() & 0x800) == 0 && (control.getStyle() & 8) != 0 && control.getBackground().equals((Object)control.getParent().getBackground());
    }

    private static String createPasswordText(String text) {
        char[] chars = new char[text.length()];
        Arrays.fill(chars, '*');
        return new String(chars);
    }

    private String replaceLinkTags(String s) {
        Pattern openTag = Pattern.compile("<a.*?>", 2);
        Pattern closeTag = Pattern.compile("</a>", 2);
        s = openTag.matcher(s).replaceAll("[");
        s = closeTag.matcher(s).replaceAll("]");
        return s;
    }

    public Screen getScreen() {
        return this.screen;
    }
}

