/*
 * Decompiled with CFR 0.152.
 */
package com.wireframesketcher.ui.eclipse;

import com.wireframesketcher.ui.eclipse.Eclipse37Compatibility;
import com.wireframesketcher.ui.eclipse.ImageDataProviderCompat;
import com.wireframesketcher.ui.eclipse.ImageGcDrawerCompat;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.Graphics;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public abstract class Compatibility {
    private static Compatibility compatibility;

    public static Compatibility getCompatibility() {
        if (compatibility == null) {
            compatibility = Compatibility.createCompatibility();
        }
        return compatibility;
    }

    private static Compatibility createCompatibility() {
        Compatibility compatibility = null;
        Version version = Compatibility.getEclipseVersion();
        int n2 = version.getMajor();
        int n3 = version.getMinor();
        String string = Compatibility.getPackageName();
        for (int i2 = n2; i2 >= 3 && compatibility == null; --i2) {
            int n4;
            int n5 = n4 = i2 == n2 ? n3 : 9;
            while (n4 >= 0 && compatibility == null) {
                String string2 = string + ".Eclipse" + Integer.toString(i2) + Integer.toString(n4) + "Compatibility";
                try {
                    compatibility = (Compatibility)Class.forName(string2).newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                --n4;
            }
        }
        if (compatibility == null) {
            compatibility = new Eclipse37Compatibility();
        }
        return compatibility;
    }

    private static String getPackageName() {
        String string = Compatibility.class.getName();
        return string.substring(0, string.lastIndexOf(46));
    }

    private static Version getPluginVersion(String string) {
        Bundle bundle = Platform.getBundle((String)string);
        if (bundle == null) {
            return null;
        }
        String string2 = (String)bundle.getHeaders().get("Bundle-Version");
        return Version.parseVersion((String)string2);
    }

    public static Version getEclipseVersion() {
        Version version = Compatibility.getPluginVersion("org.eclipse.platform");
        if (version == null) {
            version = Compatibility.getPluginVersion("org.eclipse.rcp");
        }
        if (version == null) {
            version = Version.emptyVersion;
        }
        return version;
    }

    public static Version getDraw2dVersion() {
        return Compatibility.getPluginVersion("org.eclipse.draw2d");
    }

    public static Version getGEFVersion() {
        return Compatibility.getPluginVersion("org.eclipse.gef");
    }

    public abstract void setAlwaysShowScrollbars(StyledText var1, boolean var2);

    public abstract void setLineDashOffset(Graphics var1, float var2);

    public abstract Image createImage(Device var1, ImageDataProviderCompat var2);

    public abstract Image createImage(Device var1, ImageData var2);

    public abstract ImageData getImageDataAtCurrentZoom(Image var1);

    public abstract ImageData getImageDataAtCurrentZoom(ImageDescriptor var1);

    public abstract ImageData getImageData(Image var1, int var2);

    public abstract int getDeviceZoom();

    public abstract Image createAutoScaledImage(Device var1, ImageData var2);

    public abstract Image createImage(Device var1, ImageGcDrawerCompat var2);
}

