/*
 * Decompiled with CFR 0.152.
 */
package com.wireframesketcher.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum BorderStyle implements Enumerator
{
    NONE(0, "None", "none"),
    SOLID(1, "Solid", "solid"),
    SOLID_ROUNDED(2, "SolidRounded", "solid-rounded"),
    DASHED_ROUNDED(3, "DashedRounded", "dashed-rounded");

    public static final int NONE_VALUE = 0;
    public static final int SOLID_VALUE = 1;
    public static final int SOLID_ROUNDED_VALUE = 2;
    public static final int DASHED_ROUNDED_VALUE = 3;
    private static final BorderStyle[] VALUES_ARRAY;
    public static final List<BorderStyle> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static BorderStyle get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            BorderStyle result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static BorderStyle getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            BorderStyle result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static BorderStyle get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return SOLID;
            }
            case 2: {
                return SOLID_ROUNDED;
            }
            case 3: {
                return DASHED_ROUNDED;
            }
        }
        return null;
    }

    private BorderStyle(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new BorderStyle[]{NONE, SOLID, SOLID_ROUNDED, DASHED_ROUNDED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

