/*
 * Decompiled with CFR 0.152.
 */
package com.wireframesketcher.model;

import com.wireframesketcher.model.IconSize;

public final class IconDesc {
    public static final String ASSETS_PREFIX = "assets/";
    private final String name;
    private final IconSize size;

    public IconDesc(String name, IconSize size) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (size == null) {
            throw new NullPointerException("size");
        }
        this.name = name;
        this.size = size;
    }

    public String getName() {
        return this.name;
    }

    public IconSize getSize() {
        return this.size;
    }

    public IconDesc resize(IconSize newSize) {
        if (this.size == newSize) {
            return this;
        }
        return new IconDesc(this.name, newSize);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IconDesc)) {
            return false;
        }
        IconDesc other = (IconDesc)obj;
        return this.name.equals(other.name) && this.size == other.size;
    }

    public int hashCode() {
        return this.name.hashCode() * 37 + this.size.getValue();
    }

    public String toString() {
        return this.name + " (" + this.size.getLiteral() + ")";
    }

    public static IconDesc createFromString(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        int openParenIdx = s.indexOf(40);
        if (openParenIdx == -1) {
            return new IconDesc(s.trim(), IconSize.SMALL_LITERAL);
        }
        String name = s.substring(0, openParenIdx).trim();
        int closeParenIdx = s.indexOf(41, openParenIdx + 1);
        String sizeLiteral = closeParenIdx == -1 ? s.substring(openParenIdx + 1).trim() : s.substring(openParenIdx + 1, closeParenIdx).trim();
        IconSize size = IconSize.get(sizeLiteral);
        if (size == null) {
            size = IconSize.SMALL_LITERAL;
        }
        return new IconDesc(name, size);
    }

    public IconSize getActualSize(int w, int h) {
        IconSize size = w == -1 && h == -1 ? this.getSize() : (w == 16 && h == 16 ? IconSize.SMALL_LITERAL : (w == 24 && h == 24 ? IconSize.MEDIUM_LITERAL : (w == 32 && h == 32 ? IconSize.LARGE_LITERAL : (w == 48 && h == 48 ? IconSize.XLARGE_LITERAL : (w == 128 && h == 128 ? IconSize.XXL_LITERAL : IconSize.CUSTOM_LITERAL)))));
        return size;
    }

    public int getSizePixels() {
        return this.getSize().getSizePixels();
    }

    public static IconDesc createAssetIcon(String name, IconSize size) {
        return new IconDesc(ASSETS_PREFIX + name, size);
    }

    public boolean isAssetIcon() {
        return this.name.startsWith(ASSETS_PREFIX);
    }
}

