/*
 * Decompiled with CFR 0.152.
 */
package com.wireframesketcher.model;

import java.util.StringTokenizer;

public final class LayoutParams {
    public static final int ANCHOR_NONE = 0;
    public static final int ANCHOR_START = 1;
    public static final int ANCHOR_CENTER = 4;
    public static final int ANCHOR_END = 8;
    public static final int ANCHOR_START_END = 9;
    public static final LayoutParams NONE = new LayoutParams(0, 0);
    private static final int[] FLAGS = new int[]{1, 4, 8};
    private static final String[] FLAG_STRINGS_H = new String[]{"anchor-left", "anchor-center", "anchor-right"};
    private static final String[] FLAG_STRINGS_V = new String[]{"anchor-top", "anchor-middle", "anchor-bottom"};
    private final int horizontal;
    private final int vertical;

    private LayoutParams(int horizontal, int vertical) {
        this.horizontal = horizontal;
        this.vertical = vertical;
    }

    public int getHorizontal() {
        return this.horizontal;
    }

    public int getVertical() {
        return this.vertical;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LayoutParams)) {
            return false;
        }
        LayoutParams other = (LayoutParams)obj;
        return this.horizontal == other.horizontal && this.vertical == other.vertical;
    }

    public int hashCode() {
        return this.horizontal * 37 + this.vertical;
    }

    public String toString() {
        if (this.horizontal == 0 && this.vertical == 0) {
            return "none";
        }
        StringBuilder b = new StringBuilder();
        this.formatFlags(b, this.horizontal, FLAG_STRINGS_H);
        if (this.vertical != 0) {
            b.append('|');
            this.formatFlags(b, this.vertical, FLAG_STRINGS_V);
        }
        return b.toString();
    }

    private void formatFlags(StringBuilder b, int flags, String[] strings) {
        boolean empty = true;
        for (int i = 0; i < FLAGS.length; ++i) {
            if ((flags & FLAGS[i]) == 0) continue;
            if (!empty) {
                b.append(',');
            }
            b.append(strings[i]);
            empty = false;
        }
    }

    public static LayoutParams createFromString(String s) {
        if (s == null) {
            return NONE;
        }
        if ((s = s.trim()).length() == 0) {
            return NONE;
        }
        StringTokenizer tok = new StringTokenizer(s, ",|", true);
        int horizontal = LayoutParams.parseFlags(tok, FLAG_STRINGS_H);
        int vertical = LayoutParams.parseFlags(tok, FLAG_STRINGS_V);
        return LayoutParams.create(horizontal, vertical);
    }

    private static int parseFlags(StringTokenizer tok, String[] strings) {
        String s;
        int flags = 0;
        block0: while (tok.hasMoreTokens() && !"|".equals(s = tok.nextToken())) {
            if (",".equals(s)) continue;
            s = s.trim();
            for (int i = 0; i < FLAGS.length; ++i) {
                if (!strings[i].equals(s)) continue;
                flags |= FLAGS[i];
                continue block0;
            }
        }
        return flags;
    }

    public static LayoutParams create(int horizontal, int vertical) {
        if (horizontal == 0 && vertical == 0) {
            return NONE;
        }
        LayoutParams value = LayoutParamsCache.get(horizontal = LayoutParams.validateFlags(horizontal), vertical = LayoutParams.validateFlags(vertical));
        if (value == null) {
            value = new LayoutParams(horizontal, vertical);
        }
        return value;
    }

    private static int validateFlags(int flags) {
        if ((flags & 4) != 0) {
            flags &= 0xFFFFFFF6;
        }
        return flags;
    }

    private static final class LayoutParamsCache {
        private static final LayoutParams[] cache = new LayoutParams[25];

        private LayoutParamsCache() {
        }

        public static LayoutParams get(int horizontal, int vertical) {
            LayoutParams found = null;
            for (int i = 0; i < cache.length && found == null; ++i) {
                LayoutParams value = cache[i];
                if (value == null) {
                    LayoutParamsCache.cache[i] = found = (value = new LayoutParams(horizontal, vertical));
                    continue;
                }
                if (value.horizontal != horizontal || value.vertical != vertical) continue;
                found = value;
            }
            return found;
        }
    }
}

