/*
 * Decompiled with CFR 0.152.
 */
package com.wireframesketcher.model;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;

public final class LineHeight {
    private static final int NORMAL_VALUE = -1;
    private static final String NORMAL_VALUE_STRING = "normal";
    public static final LineHeight NORMAL = new LineHeight(-1, Unit.EM);
    private static final NumberFormat EM_FORMAT;
    private final int value;
    private final Unit unit;

    private LineHeight(int value, Unit unit) {
        if (unit == null) {
            throw new NullPointerException();
        }
        this.value = value;
        this.unit = unit;
    }

    public boolean isNormal() {
        return this.value == -1;
    }

    public int getValue() {
        return this.value;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(Unit defaultUnit) {
        if (defaultUnit == this.unit || this.isNormal()) {
            return this.convertValueToString();
        }
        return this.convertValueToString() + this.unit.suffix;
    }

    private String convertValueToString() {
        if (this.isNormal()) {
            return NORMAL_VALUE_STRING;
        }
        if (this.unit == Unit.EM) {
            return EM_FORMAT.format((double)this.value / 100.0);
        }
        return Integer.toString(this.value);
    }

    public static LineHeight createFromString(String s) throws NumberFormatException {
        return LineHeight.createFromString(s, Unit.EM);
    }

    public static LineHeight createFromString(String s, Unit defaultUnit) throws NumberFormatException {
        int size;
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        if (NORMAL_VALUE_STRING.equals(s)) {
            return NORMAL;
        }
        Unit unit = defaultUnit;
        Unit[] units = Unit.ALL;
        for (int i = 0; i < units.length; ++i) {
            Unit u = units[i];
            if (!s.endsWith(u.suffix)) continue;
            unit = u;
            s = s.substring(0, s.length() - u.suffix.length());
            break;
        }
        try {
            size = unit == Unit.EM ? (int)Math.round(Double.parseDouble(s) * 100.0) : Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Invalid line height format: " + s);
        }
        return new LineHeight(size, unit);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LineHeight)) {
            return false;
        }
        LineHeight other = (LineHeight)obj;
        return this.value == other.value && this.unit == other.unit;
    }

    public int hashCode() {
        return this.value * 37 + this.unit.hashCode();
    }

    public static LineHeight inPixels(int height) {
        return new LineHeight(height, Unit.PIXELS);
    }

    public static LineHeight inPercents(int height) {
        return new LineHeight(height, Unit.PERCENTS);
    }

    public static LineHeight inEm(double height) {
        return new LineHeight((int)Math.round(height * 100.0), Unit.EM);
    }

    public int toIntPixels(int fontSize) {
        if (this.isNormal()) {
            throw new IllegalStateException();
        }
        if (this.unit == Unit.PIXELS) {
            return this.value;
        }
        return fontSize * this.value / 100;
    }

    public LineHeight toEm() {
        if (this.isNormal()) {
            return this;
        }
        if (this.unit == Unit.PIXELS) {
            throw new IllegalStateException();
        }
        if (this.unit == Unit.EM) {
            return this;
        }
        return new LineHeight(this.value, Unit.EM);
    }

    static {
        DecimalFormat format = (DecimalFormat)DecimalFormat.getNumberInstance();
        format.setMinimumFractionDigits(1);
        format.setMaximumFractionDigits(2);
        format.setDecimalSeparatorAlwaysShown(true);
        DecimalFormatSymbols symbols = format.getDecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        format.setDecimalFormatSymbols(symbols);
        EM_FORMAT = format;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Unit {
        PIXELS("px"),
        PERCENTS("%"),
        EM("em");

        static Unit[] ALL;
        private final String suffix;

        private Unit(String suffix) {
            if (suffix == null) {
                throw new NullPointerException();
            }
            this.suffix = suffix;
        }

        static {
            ALL = new Unit[]{PIXELS, PERCENTS, EM};
        }
    }
}

