/*
 * Decompiled with CFR 0.152.
 */
package com.wireframesketcher.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum LineStyle implements Enumerator
{
    SOLID(0, "Solid", "solid"),
    DOTTED(1, "Dotted", "dotted"),
    DASHED(2, "Dashed", "dashed");

    public static final int SOLID_VALUE = 0;
    public static final int DOTTED_VALUE = 1;
    public static final int DASHED_VALUE = 2;
    private static final LineStyle[] VALUES_ARRAY;
    public static final List<LineStyle> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static LineStyle get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            LineStyle result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static LineStyle getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            LineStyle result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static LineStyle get(int value) {
        switch (value) {
            case 0: {
                return SOLID;
            }
            case 1: {
                return DOTTED;
            }
            case 2: {
                return DASHED;
            }
        }
        return null;
    }

    private LineStyle(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new LineStyle[]{SOLID, DOTTED, DASHED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

