/*
 * Decompiled with CFR 0.152.
 */
package com.wireframesketcher.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum State implements Enumerator
{
    NORMAL(0, "Normal", "normal"),
    DISABLED(1, "Disabled", "disabled"),
    SELECTED(2, "Selected", "selected"),
    FOCUSED(3, "Focused", "focused");

    public static final int NORMAL_VALUE = 0;
    public static final int DISABLED_VALUE = 1;
    public static final int SELECTED_VALUE = 2;
    public static final int FOCUSED_VALUE = 3;
    private static final State[] VALUES_ARRAY;
    public static final List<State> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static State get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            State result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static State getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            State result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static State get(int value) {
        switch (value) {
            case 0: {
                return NORMAL;
            }
            case 1: {
                return DISABLED;
            }
            case 2: {
                return SELECTED;
            }
            case 3: {
                return FOCUSED;
            }
        }
        return null;
    }

    private State(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new State[]{NORMAL, DISABLED, SELECTED, FOCUSED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

