/*
 * Decompiled with CFR 0.152.
 */
package com.wireframesketcher.model;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionDesc
implements Comparable<VersionDesc> {
    public static final VersionDesc NO_VERSION = new VersionDesc(0, 0, 0);
    private static final String SEPARATOR = ".";
    private final int major;
    private final int minor;
    private final int micro;
    private final String qualifier;

    public VersionDesc(int major, int minor, int micro) {
        this(major, minor, micro, null);
    }

    public VersionDesc(int major, int minor, int micro, String qualifier) {
        if (qualifier == null) {
            qualifier = "";
        }
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.qualifier = qualifier;
    }

    public static VersionDesc parseVersion(String version) throws IllegalArgumentException {
        if (version == null || version.length() == 0) {
            return NO_VERSION;
        }
        int major = 0;
        int minor = 0;
        int micro = 0;
        String qualifier = "";
        try {
            StringTokenizer st = new StringTokenizer(version, SEPARATOR);
            major = Integer.parseInt(st.nextToken());
            if (st.hasMoreTokens()) {
                minor = Integer.parseInt(st.nextToken());
                if (st.hasMoreTokens()) {
                    micro = Integer.parseInt(st.nextToken());
                    if (st.hasMoreTokens()) {
                        qualifier = st.nextToken();
                    }
                }
            }
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("Invalid version: " + version);
        }
        return new VersionDesc(major, minor, micro, qualifier);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(20 + this.qualifier.length());
        buf.append(this.major);
        buf.append(SEPARATOR);
        buf.append(this.minor);
        buf.append(SEPARATOR);
        buf.append(this.micro);
        if (this.qualifier.length() > 0) {
            buf.append(SEPARATOR);
            buf.append(this.qualifier);
        }
        return buf.toString();
    }

    public int hashCode() {
        return (this.major << 24) + (this.minor << 16) + (this.micro << 8) + this.qualifier.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof VersionDesc)) {
            return false;
        }
        VersionDesc other = (VersionDesc)object;
        return this.major == other.major && this.minor == other.minor && this.micro == other.micro && this.qualifier.equals(other.qualifier);
    }

    @Override
    public int compareTo(VersionDesc other) {
        int result = this.major - other.major;
        if (result == 0 && (result = this.minor - other.minor) == 0 && (result = this.micro - other.micro) == 0) {
            result = this.qualifier.compareTo(other.qualifier);
        }
        return result;
    }
}

