/*
 * Decompiled with CFR 0.152.
 */
package com.wireframesketcher.model.impl;

import com.wireframesketcher.model.Font;
import com.wireframesketcher.model.FontSupport;
import com.wireframesketcher.model.Item;
import com.wireframesketcher.model.ItemSupport;
import com.wireframesketcher.model.Master;
import com.wireframesketcher.model.ModelPackage;
import com.wireframesketcher.model.Screen;
import com.wireframesketcher.model.Widget;
import com.wireframesketcher.model.WidgetContainer;
import com.wireframesketcher.model.impl.Diff;
import com.wireframesketcher.model.impl.MasterImpl;
import com.wireframesketcher.model.impl.ModelXMLResourceImpl;
import com.wireframesketcher.model.overrides.Delete;
import com.wireframesketcher.model.overrides.FontOverrides;
import com.wireframesketcher.model.overrides.Insert;
import com.wireframesketcher.model.overrides.ItemOverrides;
import com.wireframesketcher.model.overrides.Move;
import com.wireframesketcher.model.overrides.Operation;
import com.wireframesketcher.model.overrides.Overrides;
import com.wireframesketcher.model.overrides.OverridesFactory;
import com.wireframesketcher.model.overrides.OverridesPackage;
import com.wireframesketcher.model.overrides.Reference;
import com.wireframesketcher.model.overrides.WidgetContainerOverrides;
import com.wireframesketcher.model.overrides.WidgetOverrides;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OverridesHelper
implements MasterImpl.IInstanceStrategy {
    private final MasterImpl master;
    private boolean computingOverrides;
    private Map<EObject, EObject> copies;
    private Map<EObject, EObject> reverseCopies;
    private Map<EObject, EObject> insertCopies;
    private Map<EObject, EObject> reverseInsertCopies;
    private boolean staleInstance = true;
    private boolean computingInstance;
    private boolean staleOverrides;
    private final Adapter masterChangeTracker = new EContentAdapter(){

        protected void setTarget(EObject target) {
            WidgetContainer ref;
            super.setTarget(target);
            if (target == OverridesHelper.this.master && (ref = ((Master)target).getScreen()) != null) {
                this.addAdapter((Notifier)ref);
            }
        }

        protected void unsetTarget(EObject target) {
            WidgetContainer ref;
            super.unsetTarget(target);
            if (target == OverridesHelper.this.master && (ref = ((Master)target).getScreen()) != null) {
                this.removeAdapter((Notifier)ref);
            }
        }

        public void notifyChanged(Notification msg) {
            super.notifyChanged(msg);
            if (msg.getFeature() == ModelPackage.Literals.MASTER__SCREEN) {
                if (msg.getNotifier() == OverridesHelper.this.master) {
                    this.handleContainment(msg);
                }
            } else if (msg.isTouch()) {
                return;
            }
            if (msg.getFeature() == ModelPackage.Literals.MASTER__SCREEN) {
                if (msg.getNotifier() == OverridesHelper.this.master) {
                    OverridesHelper.this.staleInstance = true;
                    if (OverridesHelper.this.master.eIsSet((EStructuralFeature)ModelPackage.Literals.MASTER__INSTANCE)) {
                        OverridesHelper.this.computeInstance();
                    }
                }
            } else if (msg.getFeature() == ModelPackage.Literals.MASTER__OVERRIDES) {
                if (msg.getNotifier() == OverridesHelper.this.master) {
                    if (OverridesHelper.this.computingOverrides) {
                        return;
                    }
                    OverridesHelper.this.staleInstance = true;
                    if (OverridesHelper.this.master.eIsSet((EStructuralFeature)ModelPackage.Literals.MASTER__INSTANCE)) {
                        OverridesHelper.this.computeInstance();
                    }
                }
            } else if (msg.getFeature() == ModelPackage.Literals.MASTER__INSTANCE && msg.getNotifier() != OverridesHelper.this.master && !OverridesHelper.this.computingInstance) {
                OverridesHelper.this.staleInstance = true;
                if (OverridesHelper.this.master.eIsSet((EStructuralFeature)ModelPackage.Literals.MASTER__INSTANCE)) {
                    OverridesHelper.this.computeInstance();
                }
            }
        }
    };
    private final Adapter instanceChangeTracker = new EContentAdapter(){

        protected void setTarget(EObject target) {
            WidgetContainer instance;
            super.setTarget(target);
            if (target instanceof Master && (instance = ((Master)target).getInstance()) != null) {
                this.addAdapter((Notifier)instance);
            }
        }

        protected void unsetTarget(EObject target) {
            WidgetContainer instance;
            super.unsetTarget(target);
            if (target instanceof Master && (instance = ((Master)target).getInstance()) != null) {
                this.removeAdapter((Notifier)instance);
            }
        }

        public void notifyChanged(Notification notification) {
            EStructuralFeature feature;
            super.notifyChanged(notification);
            if (!notification.isTouch() && (feature = (EStructuralFeature)notification.getFeature()) != null && !OverridesHelper.ignoreFeature(feature)) {
                if (feature == ModelPackage.Literals.MASTER__SCREEN) {
                    return;
                }
                if (notification.getNotifier() == ((OverridesHelper)OverridesHelper.this).master.instance && feature != ModelPackage.Literals.WIDGET_CONTAINER__WIDGETS) {
                    return;
                }
                if (!OverridesHelper.this.updateOverrides(notification)) {
                    OverridesHelper.this.computeOverrides();
                }
            }
        }
    };
    private final Comparator<EObject> comparator = new Comparator<EObject>(){

        @Override
        public int compare(EObject left, EObject right) {
            return OverridesHelper.this.copies.get(left) == right ? 0 : 1;
        }
    };
    private static final MasterImpl.IInstanceStrategy INSTANCE_COPY = new MasterImpl.IInstanceStrategy(){

        public void computeInstance() {
        }
    };

    public OverridesHelper(MasterImpl master) {
        this.master = master;
        master.eAdapters().add((Object)this.masterChangeTracker);
    }

    @Override
    public void computeInstance() {
        if (!this.staleInstance) {
            return;
        }
        this.computingInstance = true;
        this.cleanupOldInstance();
        WidgetContainer screen = this.master.getScreen();
        WidgetContainer instance = null;
        if (OverridesHelper.exists(screen)) {
            EcoreUtil.Copier copier = new EcoreUtil.Copier(){

                protected EObject createCopy(EObject eObject) {
                    EObject copy = super.createCopy(eObject);
                    if (eObject instanceof Master) {
                        MasterImpl master = (MasterImpl)eObject;
                        MasterImpl masterCopy = (MasterImpl)copy;
                        masterCopy.setInstanceStrategy(INSTANCE_COPY);
                        masterCopy.setInstance((WidgetContainer)this.copy(master.getInstance()));
                    }
                    return copy;
                }

                protected void copyAttribute(EAttribute eAttribute, EObject eObject, EObject copyEObject) {
                    if (!OverridesHelper.disableInheritance(eAttribute)) {
                        super.copyAttribute(eAttribute, eObject, copyEObject);
                    }
                }
            };
            EObject result = copier.copy((EObject)screen);
            copier.copyReferences();
            this.copies = copier;
            instance = (WidgetContainer)result;
            this.applyOverrides(instance);
            instance.eAdapters().add((Object)this.instanceChangeTracker);
        }
        this.staleInstance = false;
        this.master.setInstance(instance);
        this.computingInstance = false;
    }

    private void applyOverrides(WidgetContainer instance) {
        Overrides overrides = this.master.getOverrides();
        if (overrides == null) {
            return;
        }
        try {
            OverridesApplier applier = new OverridesApplier(this.master.getScreen(), instance);
            applier.applyOverrides(overrides);
            this.setInsertCopies(applier.getInsertCopies());
            if (applier.missingReferences) {
                this.staleOverrides = true;
            }
        }
        catch (Exception e) {
            this.staleOverrides = true;
            EcorePlugin.INSTANCE.log((Object)e);
        }
    }

    private void cleanupOldInstance() {
        if (this.copies != null) {
            this.copies = null;
        }
        if (this.reverseCopies != null) {
            this.reverseCopies = null;
        }
        if (this.master.instance != null) {
            this.master.instance.eAdapters().remove((Object)this.instanceChangeTracker);
        }
    }

    private Map<EObject, EObject> getReverseCopies() {
        if (this.reverseCopies == null) {
            this.reverseCopies = OverridesHelper.computeReverseMap(this.copies);
        }
        return this.reverseCopies;
    }

    private Map<EObject, EObject> getReverseInsertCopies() {
        if (this.insertCopies == null) {
            return null;
        }
        if (this.reverseInsertCopies == null) {
            this.reverseInsertCopies = OverridesHelper.computeReverseMap(this.insertCopies);
        }
        return this.reverseInsertCopies;
    }

    private static Map<EObject, EObject> computeReverseMap(Map<EObject, EObject> map) {
        int size = map.size();
        HashMap<EObject, EObject> reverseMap = new HashMap<EObject, EObject>(size);
        for (Map.Entry<EObject, EObject> entry : map.entrySet()) {
            reverseMap.put(entry.getValue(), entry.getKey());
        }
        if (size != reverseMap.size()) {
            throw new IllegalStateException();
        }
        return reverseMap;
    }

    private void computeOverrides() {
        OverridesCalculator overridesCalculator = new OverridesCalculator(this.master.getScreen(), this.master.instance);
        this.setOverrides(overridesCalculator.calculateOverrides());
        this.setInsertCopies(overridesCalculator.getInsertCopies());
        this.staleOverrides = false;
    }

    private void setOverrides(Overrides overrides) {
        this.computingOverrides = true;
        try {
            this.master.setOverrides(overrides);
        }
        finally {
            this.computingOverrides = false;
        }
    }

    public void setInsertCopies(Map<EObject, EObject> insertCopies) {
        this.insertCopies = insertCopies;
        this.reverseInsertCopies = null;
    }

    private boolean updateOverrides(Notification notification) {
        if (this.staleOverrides) {
            return false;
        }
        Overrides overrides = this.master.getOverrides();
        OverridesUpdater updater = new OverridesUpdater(this.master.getScreen(), this.master.instance);
        boolean updated = updater.updateOverrides(overrides, notification);
        if (updated) {
            this.setOverrides(updater.getUpdatedOverrides());
        }
        return updated;
    }

    private static boolean ignoreFeature(EStructuralFeature feature) {
        return !feature.isChangeable() || feature.isDerived() || feature.isTransient();
    }

    private static boolean disableInheritance(EAttribute feature) {
        return feature == ModelPackage.Literals.NOTE_SUPPORT__NOTE;
    }

    private static boolean exists(WidgetContainer ref) {
        return ref != null && !ref.eIsProxy();
    }

    public static Widget getSourceWidget(Widget widget) {
        Widget insertedWidget;
        EObject parent;
        for (parent = widget.eContainer(); !(parent == null || parent instanceof MasterImpl && ((MasterImpl)parent).getInstanceStrategy() != INSTANCE_COPY); parent = parent.eContainer()) {
        }
        if (parent == null) {
            return widget;
        }
        MasterImpl master = (MasterImpl)parent;
        OverridesHelper overridesHelper = (OverridesHelper)master.getInstanceStrategy();
        Map<EObject, EObject> reverseInsertCopies = overridesHelper.getReverseInsertCopies();
        if (reverseInsertCopies != null && (insertedWidget = (Widget)reverseInsertCopies.get(widget)) != null) {
            return insertedWidget;
        }
        Widget sourceWidget = (Widget)overridesHelper.getReverseCopies().get(widget);
        if (sourceWidget == null) {
            return null;
        }
        return OverridesHelper.getSourceWidget(sourceWidget);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Helper {
        protected final WidgetContainer leftRoot;
        protected final WidgetContainer rightRoot;
        private String leftUri;
        private Map<EObject, EObject> insertCopies;

        public Helper(WidgetContainer leftRoot, WidgetContainer rightRoot) {
            this.leftRoot = leftRoot;
            this.rightRoot = rightRoot;
        }

        protected void registerCopies(Map<EObject, EObject> copies) {
            if (this.insertCopies == null) {
                this.insertCopies = copies;
            } else {
                this.insertCopies.putAll(copies);
            }
        }

        public Map<EObject, EObject> getInsertCopies() {
            return this.insertCopies;
        }

        protected String getItemURIFragment(Item item) {
            return ((InternalEObject)item.eContainer()).eURIFragmentSegment(item.eContainingFeature(), (EObject)item);
        }

        protected String getRelativeWidgetURI(Widget widget) {
            String uri = this.getURI(widget);
            String containerUri = this.getURI(widget.eContainer());
            if (uri.startsWith("/") && uri.startsWith(containerUri) && (uri = uri.substring(containerUri.length())).length() == 0) {
                uri = null;
            }
            return uri;
        }

        private String getURI(EObject object) {
            return ((ModelXMLResourceImpl)this.leftRoot.eResource()).getDefaultURIFragment(object);
        }

        private String getLeftURI() {
            if (this.leftUri == null) {
                this.leftUri = this.getURI(this.leftRoot);
            }
            return this.leftUri;
        }

        protected Item getItemForURIFragment(EObject container, String uriFragment) {
            if (uriFragment == null) {
                return null;
            }
            EObject object = ((InternalEObject)container).eObjectForURIFragmentSegment(uriFragment);
            if (!(object instanceof Item)) {
                return null;
            }
            return (Item)object;
        }

        protected Widget getWidgetForURI(String uri) {
            if (uri == null) {
                return null;
            }
            try {
                if (this.isNestedWidgetURI(uri)) {
                    return this.getNestedWidgetForURI(uri);
                }
                EObject object = this.leftRoot.eResource().getEObject(uri);
                if (!(object instanceof Widget)) {
                    return null;
                }
                Widget widget = (Widget)object;
                if (this.isInsertWidget(widget)) {
                    widget = (Widget)this.getInsertedInstance(widget);
                }
                return widget;
            }
            catch (Exception e) {
                EcorePlugin.INSTANCE.log((Object)e);
                return null;
            }
        }

        private EObject getInsertedInstance(EObject object) {
            Master master = this.getMasterContainer(object);
            if (master == null) {
                return null;
            }
            if (!this.isDirectContent(master)) {
                return null;
            }
            MasterImpl masterImpl = (MasterImpl)master;
            OverridesHelper overridesHelper = (OverridesHelper)masterImpl.getInstanceStrategy();
            if (overridesHelper.insertCopies != null) {
                return (EObject)overridesHelper.insertCopies.get(object);
            }
            return null;
        }

        protected String getAbsoluteURI(EObject container, Reference ref) {
            String uri = ref.getRef();
            if (uri == null) {
                return null;
            }
            if (uri.startsWith("/")) {
                String containerUri = container == this.leftRoot ? this.getLeftURI() : this.getURI(container);
                uri = containerUri + uri;
            }
            return uri;
        }

        protected Master getMasterContainer(EObject object) {
            Master master = null;
            for (EObject parent = object.eContainer(); master == null && parent != null && parent != this.leftRoot; parent = parent.eContainer()) {
                if (!(parent instanceof Master)) continue;
                master = (Master)parent;
            }
            return master;
        }

        private boolean isDirectContent(EObject object) {
            EObject parent;
            for (parent = object.eContainer(); parent != null && parent != this.leftRoot; parent = parent.eContainer()) {
                if (!(parent instanceof Master)) continue;
                return false;
            }
            return parent == this.leftRoot;
        }

        private boolean isInsertWidget(Widget widget) {
            Widget object = widget;
            while (object != null) {
                if ((object = object.eContainer()) instanceof Insert) {
                    return true;
                }
                if (!(object instanceof Screen) && !(object instanceof Master)) continue;
                return false;
            }
            return false;
        }

        protected String getWidgetURI(Widget widget) {
            String uri = null;
            if (!this.isDirectContent(widget)) {
                uri = this.getNestedWidgetURI(widget);
            }
            if (uri != null) {
                return uri;
            }
            uri = this.getURI(widget);
            String leftUri = this.getLeftURI();
            if (uri.startsWith("/") && uri.startsWith(leftUri) && (uri = uri.substring(leftUri.length())).length() == 0) {
                uri = null;
            }
            return uri;
        }

        protected Long getSourceWidgetId(Widget widget) {
            Widget sourceWidget = OverridesHelper.getSourceWidget(widget);
            if (sourceWidget != null) {
                return sourceWidget.getId();
            }
            return null;
        }

        private Widget getCopyWidgetForId(WidgetContainer container, List<Long> idPath, int index) {
            if (container == null) {
                return null;
            }
            String idFragment = idPath.get(index).toString();
            Widget widget = (Widget)container.eResource().getEObject(idFragment);
            if (widget == null) {
                return null;
            }
            if (index == idPath.size() - 1) {
                if (this.isInsertWidget(widget)) {
                    MasterImpl master = (MasterImpl)this.getMasterContainer(widget);
                    OverridesHelper overridesHelper = (OverridesHelper)master.getInstanceStrategy();
                    if (overridesHelper.insertCopies != null) {
                        return (Widget)overridesHelper.insertCopies.get(widget);
                    }
                    return null;
                }
                return widget;
            }
            if (!(widget instanceof MasterImpl)) {
                return null;
            }
            MasterImpl master = (MasterImpl)widget;
            if (!OverridesHelper.exists(master.getScreen())) {
                return null;
            }
            OverridesHelper overridesHelper = (OverridesHelper)master.getInstanceStrategy();
            Widget sourceWidget = this.getCopyWidgetForId(master.getScreen(), idPath, index + 1);
            return (Widget)overridesHelper.copies.get(sourceWidget);
        }

        private String getNestedWidgetURI(Widget widget) {
            EObject parent;
            ArrayList<Long> uriPath = new ArrayList<Long>();
            Widget sourceWidget = OverridesHelper.getSourceWidget(widget);
            if (sourceWidget == null) {
                return null;
            }
            Long id = sourceWidget.getId();
            if (id == null) {
                return null;
            }
            uriPath.add(id);
            if (this.isInsertWidget(sourceWidget)) {
                Resource resource = sourceWidget.eResource();
                if (resource == null) {
                    throw new NullPointerException();
                }
                boolean insertParentFound = false;
                for (parent = widget.eContainer(); parent != null && parent != this.leftRoot; parent = parent.eContainer()) {
                    if (!(parent instanceof Master)) continue;
                    Master master = (Master)parent;
                    Widget sourceMaster = OverridesHelper.getSourceWidget(master);
                    if (sourceMaster == null) {
                        return null;
                    }
                    Resource masterResource = sourceMaster.eResource();
                    if (masterResource == null) {
                        throw new NullPointerException();
                    }
                    if (!insertParentFound) {
                        if (masterResource != resource) continue;
                        insertParentFound = true;
                        continue;
                    }
                    if (masterResource != resource) break;
                }
            }
            while (parent != null && parent != this.leftRoot) {
                if (parent instanceof Master) {
                    Master master = (Master)parent;
                    id = this.getSourceWidgetId(master);
                    if (id == null) {
                        return null;
                    }
                    uriPath.add(id);
                }
                parent = parent.eContainer();
            }
            StringBuilder buf = new StringBuilder();
            for (int i = uriPath.size() - 1; i > 0; --i) {
                buf.append(uriPath.get(i));
                buf.append('/');
            }
            buf.append(uriPath.get(0));
            return buf.toString();
        }

        private boolean isNestedWidgetURI(String uri) {
            int length = uri.length();
            if (length > 1) {
                return Character.isDigit(uri.charAt(0)) && uri.indexOf(47) != -1;
            }
            return false;
        }

        private Widget getNestedWidgetForURI(String uri) {
            Long id;
            int start = 0;
            int length = uri.length();
            ArrayList<Long> idPath = new ArrayList<Long>();
            WidgetContainer container = this.leftRoot;
            for (int index = 1; index < length; ++index) {
                if (uri.charAt(index) != '/') continue;
                id = Long.parseLong(uri.substring(start, index));
                idPath.add(id);
                start = index + 1;
                ++index;
            }
            id = Long.parseLong(uri.substring(start, length));
            idPath.add(id);
            return this.getCopyWidgetForId(container, idPath, 0);
        }

        protected boolean eq(Object a, Object b) {
            if (a == null) {
                return b == null;
            }
            return b == null ? false : a.equals(b);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OverridesApplier
    extends Helper {
        public boolean missingReferences;

        public OverridesApplier(WidgetContainer leftRoot, WidgetContainer rightRoot) {
            super(leftRoot, rightRoot);
        }

        private <T extends EObject> T insertCopy(T insertedObject) {
            EcoreUtil.Copier copier = new EcoreUtil.Copier();
            EObject insertedObjectInstance = copier.copy(insertedObject);
            copier.copyReferences();
            this.registerCopies((Map<EObject, EObject>)copier);
            return (T)insertedObjectInstance;
        }

        public void applyOverrides(Overrides overrides) {
            this.applyWidgetUpdates(overrides);
            this.applyWidgetChanges(overrides);
        }

        private void applyWidgetChanges(Overrides overrides) {
            this.applyWidgetChanges(overrides, this.leftRoot, this.rightRoot);
        }

        private void applyWidgetUpdates(Overrides overrides) {
            if (!overrides.eIsSet((EStructuralFeature)OverridesPackage.Literals.OVERRIDES__WIDGETS)) {
                return;
            }
            for (WidgetOverrides widgetOverrides : overrides.getWidgets()) {
                String uri = this.getAbsoluteURI(this.leftRoot, widgetOverrides);
                Widget left = this.getWidgetForURI(uri);
                if (left == null) {
                    this.missingReferences = true;
                    continue;
                }
                Widget right = (Widget)OverridesHelper.this.copies.get(left);
                if (right == null) continue;
                this.applyAttributes(widgetOverrides, right);
                this.applyFont(widgetOverrides, right);
                this.applyItems(widgetOverrides, left, right);
                this.applyWidgetChanges(widgetOverrides, left, right);
            }
        }

        private void applyWidgetChanges(WidgetOverrides widgetOverrides, Widget left, Widget right) {
            if (left instanceof WidgetContainer) {
                this.applyWidgetChanges((WidgetContainerOverrides)widgetOverrides, (WidgetContainer)((Object)left), (WidgetContainer)((Object)right));
            } else if (left instanceof Master) {
                Master leftMaster = (Master)left;
                Master rightMaster = (Master)right;
                if (OverridesHelper.exists(leftMaster.getScreen()) && OverridesHelper.exists(rightMaster.getScreen())) {
                    this.applyWidgetChanges((WidgetContainerOverrides)widgetOverrides, leftMaster.getInstance(), rightMaster.getInstance());
                }
            }
        }

        private void applyWidgetChanges(WidgetContainerOverrides overrides, WidgetContainer left, WidgetContainer right) {
            if (!overrides.eIsSet((EStructuralFeature)OverridesPackage.Literals.WIDGET_CONTAINER_OVERRIDES__WIDGET_CHANGES)) {
                return;
            }
            EList<Widget> widgets = right.getWidgets();
            for (Operation operation : overrides.getWidgetChanges()) {
                EObject object;
                Widget rightChild;
                if (operation instanceof Delete) {
                    Delete delete = (Delete)operation;
                    Widget leftChild = this.getWidgetForURI(this.getAbsoluteURI(left, delete));
                    if (leftChild == null || (rightChild = (Widget)OverridesHelper.this.copies.get(leftChild)) == null) continue;
                    widgets.remove((Object)rightChild);
                    continue;
                }
                if (operation instanceof Move) {
                    Move move = (Move)operation;
                    Widget leftChild = this.getWidgetForURI(this.getAbsoluteURI(left, move));
                    if (leftChild == null || (rightChild = (Widget)OverridesHelper.this.copies.get(leftChild)) == null) continue;
                    int newIndex = move.getNewIndex();
                    if (newIndex >= widgets.size()) {
                        newIndex = widgets.size() - 1;
                    }
                    widgets.move(newIndex, (Object)rightChild);
                    continue;
                }
                if (!(operation instanceof Insert)) continue;
                Insert insert = (Insert)operation;
                int newIndex = insert.getNewIndex();
                if (newIndex > widgets.size()) {
                    newIndex = widgets.size();
                }
                if (!((object = insert.getObject()) instanceof Widget)) continue;
                Widget widget = this.insertCopy((Widget)object);
                widgets.add(newIndex, (Object)widget);
            }
        }

        private void applyItems(WidgetOverrides widgetOverrides, Widget left, Widget right) {
            if (!(right instanceof ItemSupport)) {
                return;
            }
            if (widgetOverrides.eIsSet((EStructuralFeature)OverridesPackage.Literals.WIDGET_OVERRIDES__ITEMS)) {
                for (ItemOverrides itemOverrides : widgetOverrides.getItems()) {
                    Item rightItem;
                    Item leftItem = this.getItemForURIFragment(left, itemOverrides.getRef());
                    if (leftItem == null || (rightItem = (Item)OverridesHelper.this.copies.get(leftItem)) == null) continue;
                    this.applyObjectAttributes(itemOverrides, rightItem);
                }
            }
            this.applyItemChanges(widgetOverrides, (ItemSupport)((Object)left), (ItemSupport)((Object)right));
        }

        private void applyItemChanges(WidgetOverrides widgetOverrides, ItemSupport left, ItemSupport right) {
            if (!widgetOverrides.eIsSet((EStructuralFeature)OverridesPackage.Literals.WIDGET_OVERRIDES__ITEM_CHANGES)) {
                return;
            }
            EList<Item> items = right.getItems();
            for (Operation operation : widgetOverrides.getItemChanges()) {
                EObject object;
                Item rightItem;
                if (operation instanceof Delete) {
                    Delete delete = (Delete)operation;
                    Item leftItem = this.getItemForURIFragment(left, delete.getRef());
                    if (leftItem == null || (rightItem = (Item)OverridesHelper.this.copies.get(leftItem)) == null) continue;
                    items.remove((Object)rightItem);
                    continue;
                }
                if (operation instanceof Move) {
                    Move move = (Move)operation;
                    Item leftItem = this.getItemForURIFragment(left, move.getRef());
                    if (leftItem == null || (rightItem = (Item)OverridesHelper.this.copies.get(leftItem)) == null) continue;
                    int newIndex = move.getNewIndex();
                    if (newIndex >= items.size()) {
                        newIndex = items.size() - 1;
                    }
                    items.move(newIndex, (Object)rightItem);
                    continue;
                }
                if (!(operation instanceof Insert)) continue;
                Insert insert = (Insert)operation;
                int newIndex = insert.getNewIndex();
                if (newIndex > items.size()) {
                    newIndex = items.size();
                }
                if (!((object = insert.getObject()) instanceof Item)) continue;
                items.add(newIndex, (Object)((Item)EcoreUtil.copy((EObject)object)));
            }
        }

        private void applyObjectAttributes(EObject objectOverrides, EObject object) {
            EList attributes = objectOverrides.eClass().getEAllAttributes();
            EClass eClass = object.eClass();
            for (EAttribute eAttribute : attributes) {
                EStructuralFeature feature;
                if (eAttribute == OverridesPackage.Literals.REFERENCE__REF || !objectOverrides.eIsSet((EStructuralFeature)eAttribute)) continue;
                if (eAttribute == OverridesPackage.Literals.WIDGET_OVERRIDES__NO_LINK) {
                    feature = eClass.getEStructuralFeature(OverridesPackage.Literals.WIDGET_OVERRIDES__LINK.getName());
                    if (!(feature instanceof EAttribute)) continue;
                    object.eUnset(feature);
                    continue;
                }
                if (eAttribute == OverridesPackage.Literals.WIDGET_OVERRIDES__NO_TEXT) {
                    feature = eClass.getEStructuralFeature(OverridesPackage.Literals.WIDGET_OVERRIDES__TEXT.getName());
                    if (!(feature instanceof EAttribute)) continue;
                    object.eUnset(feature);
                    continue;
                }
                if (eAttribute == OverridesPackage.Literals.ITEM_OVERRIDES__NO_LINK) {
                    feature = eClass.getEStructuralFeature(OverridesPackage.Literals.ITEM_OVERRIDES__LINK.getName());
                    if (!(feature instanceof EAttribute)) continue;
                    object.eUnset(feature);
                    continue;
                }
                feature = eClass.getEStructuralFeature(eAttribute.getName());
                if (!(feature instanceof EAttribute)) continue;
                object.eSet(feature, objectOverrides.eGet((EStructuralFeature)eAttribute));
            }
        }

        private void applyFont(WidgetOverrides widgetOverrides, Widget right) {
            if (!(right instanceof FontSupport)) {
                return;
            }
            FontOverrides fontOverrides = widgetOverrides.getFont();
            if (fontOverrides == null) {
                return;
            }
            Font font = ((FontSupport)((Object)right)).getFont();
            this.applyObjectAttributes(fontOverrides, font);
        }

        private void applyAttributes(WidgetOverrides widgetOverrides, Widget widget) {
            this.applyObjectAttributes(widgetOverrides, widget);
            if (widgetOverrides.eIsSet((EStructuralFeature)OverridesPackage.Literals.WIDGET_OVERRIDES__ATTRIBUTES)) {
                EClass eClass = widget.eClass();
                EMap<String, String> map = widgetOverrides.getAttributes();
                for (Map.Entry entry : map.entrySet()) {
                    EStructuralFeature feature = eClass.getEStructuralFeature((String)entry.getKey());
                    if (!(feature instanceof EAttribute)) continue;
                    widget.eSet(feature, EcoreUtil.createFromString((EDataType)((EAttribute)feature).getEAttributeType(), (String)((String)entry.getValue())));
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class OverridesCalculator
    extends Helper {
        private Overrides overrides;
        private WidgetOverrides widgetOverrides;
        private Widget widget;
        private ItemOverrides itemOverrides;
        private Item item;

        public OverridesCalculator(WidgetContainer leftRoot, WidgetContainer rightRoot) {
            super(leftRoot, rightRoot);
        }

        private Overrides getOverrides() {
            if (this.overrides == null) {
                this.overrides = OverridesFactory.eINSTANCE.createOverrides();
            }
            return this.overrides;
        }

        private <T extends EObject> T reverseInsertCopy(T insertedObjectInstance) {
            EcoreUtil.Copier copier = new EcoreUtil.Copier();
            EObject insertedObject = copier.copy(insertedObjectInstance);
            copier.copyReferences();
            this.registerCopies(OverridesHelper.computeReverseMap((Map)copier));
            return (T)insertedObject;
        }

        private WidgetOverrides getWidgetOverrides(Widget widget) {
            if (this.widgetOverrides == null || this.widget != widget) {
                WidgetOverrides widgetOverrides = OverridesFactory.eINSTANCE.createWidgetOverrides();
                widgetOverrides.setRef(this.getWidgetURI(widget));
                this.getOverrides().getWidgets().add((Object)widgetOverrides);
                this.widget = widget;
                this.widgetOverrides = widgetOverrides;
            }
            return this.widgetOverrides;
        }

        private ItemOverrides getItemOverrides(Item item) {
            if (this.itemOverrides == null || this.item != item) {
                ItemOverrides itemOverrides = OverridesFactory.eINSTANCE.createItemOverrides();
                itemOverrides.setRef(this.getItemURIFragment(item));
                this.getWidgetOverrides((Widget)item.eContainer()).getItems().add((Object)itemOverrides);
                this.item = item;
                this.itemOverrides = itemOverrides;
            }
            return this.itemOverrides;
        }

        private FontOverrides getFontOverrides(Widget widget) {
            WidgetOverrides wo = this.getWidgetOverrides(widget);
            if (wo.getFont() == null) {
                wo.setFont(OverridesFactory.eINSTANCE.createFontOverrides());
            }
            return wo.getFont();
        }

        private EList<Operation> getWidgetChanges(WidgetContainer container) {
            if (container == this.leftRoot) {
                return this.getOverrides().getWidgetChanges();
            }
            if (container.eContainer() instanceof Master) {
                return this.getWidgetOverrides((Widget)container.eContainer()).getWidgetChanges();
            }
            return this.getWidgetOverrides((Widget)((Object)container)).getWidgetChanges();
        }

        public Overrides calculateOverrides() {
            this.calculateWidgetUpdates(this.leftRoot, this.rightRoot);
            this.calculateWidgetChanges(this.leftRoot, this.rightRoot);
            return this.overrides;
        }

        private void calculateWidgetChanges(WidgetContainer left, WidgetContainer right) {
            Widget[] rightAry;
            Widget[] leftAry;
            Diff.Edit[] edits;
            EList<Widget> leftValue = left.getWidgets();
            EList<Widget> rightValue = right.getWidgets();
            if ((leftValue.size() != 0 || rightValue.size() != 0) && (edits = Diff.diffWithMoves(leftAry = (Widget[])leftValue.toArray((Object[])new Widget[leftValue.size()]), rightAry = (Widget[])rightValue.toArray((Object[])new Widget[rightValue.size()]), OverridesHelper.this.comparator)).length > 0) {
                EList<Operation> operations = this.getWidgetChanges(left);
                for (int j = 0; j < edits.length; ++j) {
                    Diff.Edit edit = edits[j];
                    if (edit.type == Diff.EditType.DELETE) {
                        Delete delete = OverridesFactory.eINSTANCE.createDelete();
                        delete.setRef(this.getRelativeWidgetURI(leftAry[edit.index0]));
                        operations.add((Object)delete);
                        continue;
                    }
                    if (edit.type == Diff.EditType.MOVE) {
                        Move move = OverridesFactory.eINSTANCE.createMove();
                        move.setRef(this.getRelativeWidgetURI(leftAry[edit.index0]));
                        move.setNewIndex(edit.index1 > edit.index0 ? edit.index1 - 1 : edit.index1);
                        operations.add((Object)move);
                        continue;
                    }
                    if (edit.type != Diff.EditType.INSERT) continue;
                    Insert insert = OverridesFactory.eINSTANCE.createInsert();
                    insert.setNewIndex(edit.index0);
                    Widget addedWidget = rightAry[edit.index1];
                    Long sourceId = this.getSourceWidgetId(addedWidget);
                    Widget addedWidgetCopy = this.reverseInsertCopy(addedWidget);
                    if (sourceId != null) {
                        addedWidgetCopy.setId(sourceId);
                    }
                    insert.setObject(addedWidgetCopy);
                    operations.add((Object)insert);
                }
            }
        }

        private void calculateWidgetUpdates(WidgetContainer left, WidgetContainer right) {
            EList<Widget> widgets = left.getWidgets();
            for (Widget leftWidget : widgets) {
                Widget rightWidget = (Widget)OverridesHelper.this.copies.get(leftWidget);
                if (rightWidget == null || rightWidget.eContainer() != right) continue;
                this.checkAttributes(leftWidget, rightWidget);
                this.checkFont(leftWidget, rightWidget);
                this.checkItems(leftWidget, rightWidget);
                this.checkWidgetUpdates(leftWidget, rightWidget);
            }
        }

        private void checkWidgetUpdates(Widget leftWidget, Widget rightWidget) {
            if (leftWidget instanceof WidgetContainer) {
                WidgetContainer leftContainer = (WidgetContainer)((Object)leftWidget);
                WidgetContainer rightContainer = (WidgetContainer)((Object)rightWidget);
                this.calculateWidgetUpdates(leftContainer, rightContainer);
                this.calculateWidgetChanges(leftContainer, rightContainer);
            } else if (leftWidget instanceof Master) {
                Master leftMaster = (Master)leftWidget;
                Master rightMaster = (Master)rightWidget;
                if (OverridesHelper.exists(leftMaster.getScreen()) && OverridesHelper.exists(rightMaster.getScreen())) {
                    WidgetContainer leftContainer = leftMaster.getInstance();
                    WidgetContainer rightContainer = rightMaster.getInstance();
                    this.calculateWidgetUpdates(leftContainer, rightContainer);
                    this.calculateWidgetChanges(leftContainer, rightContainer);
                }
            }
        }

        private void checkItems(Widget leftWidget, Widget rightWidget) {
            if (!(leftWidget instanceof ItemSupport)) {
                return;
            }
            ItemSupport leftItemSupport = (ItemSupport)((Object)leftWidget);
            ItemSupport rightItemSupport = (ItemSupport)((Object)rightWidget);
            for (Item leftItem : leftItemSupport.getItems()) {
                Item rightItem = (Item)OverridesHelper.this.copies.get(leftItem);
                if (rightItem == null || rightItem.eContainer() != rightWidget) continue;
                this.checkItemAttributes(leftItem, rightItem);
            }
            this.calculateItemChanges(leftItemSupport, rightItemSupport);
        }

        private void calculateItemChanges(ItemSupport leftWidget, ItemSupport rightWidget) {
            Item[] rightAry;
            Item[] leftAry;
            Diff.Edit[] edits;
            EList<Item> leftValue = leftWidget.getItems();
            EList<Item> rightValue = rightWidget.getItems();
            if ((leftValue.size() != 0 || rightValue.size() != 0) && (edits = Diff.diffWithMoves(leftAry = (Item[])leftValue.toArray((Object[])new Item[leftValue.size()]), rightAry = (Item[])rightValue.toArray((Object[])new Item[rightValue.size()]), OverridesHelper.this.comparator)).length > 0) {
                EList<Operation> operations = this.getWidgetOverrides((Widget)((Object)leftWidget)).getItemChanges();
                for (int j = 0; j < edits.length; ++j) {
                    Diff.Edit edit = edits[j];
                    if (edit.type == Diff.EditType.DELETE) {
                        Delete delete = OverridesFactory.eINSTANCE.createDelete();
                        delete.setRef(this.getItemURIFragment(leftAry[edit.index0]));
                        operations.add((Object)delete);
                        continue;
                    }
                    if (edit.type == Diff.EditType.MOVE) {
                        Move move = OverridesFactory.eINSTANCE.createMove();
                        move.setRef(this.getItemURIFragment(leftAry[edit.index0]));
                        move.setNewIndex(edit.index1 > edit.index0 ? edit.index1 - 1 : edit.index1);
                        operations.add((Object)move);
                        continue;
                    }
                    if (edit.type != Diff.EditType.INSERT) continue;
                    Insert insert = OverridesFactory.eINSTANCE.createInsert();
                    insert.setNewIndex(edit.index0);
                    Item addedObject = rightAry[edit.index1];
                    insert.setObject(EcoreUtil.copy((EObject)addedObject));
                    operations.add((Object)insert);
                }
            }
        }

        private void checkItemAttributes(Item leftItem, Item rightItem) {
            EClass eClass = leftItem.eClass();
            EList attributes = eClass.getEAllAttributes();
            for (EAttribute eAttribute : attributes) {
                Object rightValue;
                Object leftValue;
                if (OverridesHelper.ignoreFeature((EStructuralFeature)eAttribute) || this.eq(leftValue = leftItem.eGet((EStructuralFeature)eAttribute), rightValue = rightItem.eGet((EStructuralFeature)eAttribute))) continue;
                EStructuralFeature feature = OverridesPackage.Literals.ITEM_OVERRIDES.getEStructuralFeature(eAttribute.getName());
                if (!(feature instanceof EAttribute)) {
                    throw new IllegalStateException();
                }
                ItemOverrides o = this.getItemOverrides(leftItem);
                if (feature == OverridesPackage.Literals.ITEM_OVERRIDES__LINK) {
                    o.setNoLink(rightValue == null);
                }
                o.eSet(feature, rightValue);
            }
        }

        private void checkFont(Widget leftWidget, Widget rightWidget) {
            if (!(leftWidget instanceof FontSupport)) {
                return;
            }
            Font leftFont = ((FontSupport)((Object)leftWidget)).getFont();
            Font rightFont = ((FontSupport)((Object)rightWidget)).getFont();
            EClass eClass = leftFont.eClass();
            EList attributes = eClass.getEAllAttributes();
            for (EAttribute eAttribute : attributes) {
                Object rightValue;
                Object leftValue;
                if (OverridesHelper.ignoreFeature((EStructuralFeature)eAttribute) || this.eq(leftValue = leftFont.eGet((EStructuralFeature)eAttribute), rightValue = rightFont.eGet((EStructuralFeature)eAttribute))) continue;
                EStructuralFeature feature = OverridesPackage.Literals.FONT_OVERRIDES.getEStructuralFeature(eAttribute.getName());
                FontOverrides o = this.getFontOverrides(leftWidget);
                if (!(feature instanceof EAttribute)) {
                    throw new IllegalStateException();
                }
                o.eSet(feature, rightValue);
            }
        }

        private void checkAttributes(Widget leftWidget, Widget rightWidget) {
            EClass eClass = leftWidget.eClass();
            EList attributes = eClass.getEAllAttributes();
            for (EAttribute eAttribute : attributes) {
                Object rightValue;
                Object leftValue;
                if (OverridesHelper.ignoreFeature((EStructuralFeature)eAttribute) || this.eq(leftValue = OverridesHelper.disableInheritance(eAttribute) ? eAttribute.getDefaultValue() : leftWidget.eGet((EStructuralFeature)eAttribute), rightValue = rightWidget.eGet((EStructuralFeature)eAttribute))) continue;
                EStructuralFeature feature = OverridesPackage.Literals.WIDGET_OVERRIDES.getEStructuralFeature(eAttribute.getName());
                WidgetOverrides o = this.getWidgetOverrides(leftWidget);
                if (feature != null) {
                    if (!(feature instanceof EAttribute)) {
                        throw new IllegalStateException();
                    }
                    if (feature == OverridesPackage.Literals.WIDGET_OVERRIDES__LINK) {
                        o.setNoLink(rightValue == null);
                    } else if (feature == OverridesPackage.Literals.WIDGET_OVERRIDES__TEXT) {
                        o.setNoText(rightValue == null || "".equals(rightValue));
                    }
                    o.eSet(feature, rightValue);
                    continue;
                }
                o.getAttributes().put((Object)eAttribute.getName(), (Object)EcoreUtil.convertToString((EDataType)eAttribute.getEAttributeType(), (Object)rightValue));
            }
        }
    }

    private class OverridesUpdater
    extends Helper {
        private Overrides updatedOverrides;

        public OverridesUpdater(WidgetContainer leftRoot, WidgetContainer rightRoot) {
            super(leftRoot, rightRoot);
        }

        public Overrides getUpdatedOverrides() {
            return this.updatedOverrides;
        }

        public boolean updateOverrides(Overrides overrides, Notification notification) {
            EStructuralFeature feature = (EStructuralFeature)notification.getFeature();
            if (!(feature instanceof EAttribute)) {
                return false;
            }
            EAttribute eAttribute = (EAttribute)feature;
            Object notifier = notification.getNotifier();
            if (!(notifier instanceof EObject)) {
                return false;
            }
            EObject right = (EObject)notifier;
            EObject left = (EObject)OverridesHelper.this.getReverseCopies().get(right);
            if (left == null) {
                return false;
            }
            if (OverridesHelper.this.getReverseCopies().get(right.eContainer()) != left.eContainer()) {
                return false;
            }
            Widget leftWidget = null;
            if (left instanceof Widget) {
                leftWidget = (Widget)left;
            } else if (left instanceof Item) {
                leftWidget = (Widget)left.eContainer();
            } else if (left instanceof Font) {
                leftWidget = (Widget)left.eContainer();
            }
            if (leftWidget == null) {
                return false;
            }
            if (overrides == null) {
                overrides = OverridesFactory.eINSTANCE.createOverrides();
            }
            String uri = this.getWidgetURI(leftWidget);
            WidgetOverrides widgetOverrides = null;
            for (WidgetOverrides wo : overrides.getWidgets()) {
                if (!this.eq(uri, wo.getRef())) continue;
                widgetOverrides = wo;
                break;
            }
            if (widgetOverrides == null) {
                widgetOverrides = OverridesFactory.eINSTANCE.createWidgetOverrides();
                widgetOverrides.setRef(uri);
                overrides.getWidgets().add((Object)widgetOverrides);
            }
            if (left instanceof Widget) {
                Object leftValue = OverridesHelper.disableInheritance(eAttribute) ? eAttribute.getDefaultValue() : leftWidget.eGet((EStructuralFeature)eAttribute);
                Object rightValue = notification.getNewValue();
                EStructuralFeature f = OverridesPackage.Literals.WIDGET_OVERRIDES.getEStructuralFeature(eAttribute.getName());
                if (f != null && !(f instanceof EAttribute)) {
                    throw new IllegalStateException();
                }
                if (!this.eq(leftValue, rightValue)) {
                    if (f != null) {
                        if (f == OverridesPackage.Literals.WIDGET_OVERRIDES__LINK) {
                            widgetOverrides.setNoLink(rightValue == null);
                        } else if (f == OverridesPackage.Literals.WIDGET_OVERRIDES__TEXT) {
                            widgetOverrides.setNoText(rightValue == null || "".equals(rightValue));
                        }
                        widgetOverrides.eSet(f, rightValue);
                    } else {
                        widgetOverrides.getAttributes().put((Object)eAttribute.getName(), (Object)EcoreUtil.convertToString((EDataType)eAttribute.getEAttributeType(), (Object)rightValue));
                    }
                } else if (f != null) {
                    if (f == OverridesPackage.Literals.WIDGET_OVERRIDES__LINK) {
                        widgetOverrides.setNoLink(false);
                    } else if (f == OverridesPackage.Literals.WIDGET_OVERRIDES__TEXT) {
                        widgetOverrides.setNoText(false);
                    }
                    widgetOverrides.eUnset(f);
                } else {
                    widgetOverrides.getAttributes().remove((Object)eAttribute.getName());
                }
            } else if (left instanceof Font) {
                FontOverrides fontOverrides = widgetOverrides.getFont();
                if (fontOverrides == null) {
                    fontOverrides = OverridesFactory.eINSTANCE.createFontOverrides();
                    widgetOverrides.setFont(fontOverrides);
                }
                Object leftValue = left.eGet((EStructuralFeature)eAttribute);
                Object rightValue = notification.getNewValue();
                EStructuralFeature f = OverridesPackage.Literals.FONT_OVERRIDES.getEStructuralFeature(eAttribute.getName());
                if (!(f instanceof EAttribute)) {
                    throw new IllegalStateException();
                }
                if (!this.eq(leftValue, rightValue)) {
                    fontOverrides.eSet(f, rightValue);
                } else {
                    fontOverrides.eUnset(f);
                }
                if (this.isEmpty(fontOverrides)) {
                    widgetOverrides.setFont(null);
                }
            } else if (left instanceof Item) {
                String itemURI = this.getItemURIFragment((Item)left);
                ItemOverrides itemOverrides = null;
                for (ItemOverrides io : widgetOverrides.getItems()) {
                    if (!this.eq(itemURI, io.getRef())) continue;
                    itemOverrides = io;
                    break;
                }
                if (itemOverrides == null) {
                    itemOverrides = OverridesFactory.eINSTANCE.createItemOverrides();
                    itemOverrides.setRef(itemURI);
                    widgetOverrides.getItems().add((Object)itemOverrides);
                }
                Object leftValue = left.eGet((EStructuralFeature)eAttribute);
                Object rightValue = notification.getNewValue();
                EStructuralFeature f = OverridesPackage.Literals.ITEM_OVERRIDES.getEStructuralFeature(eAttribute.getName());
                if (!(f instanceof EAttribute)) {
                    throw new IllegalStateException();
                }
                if (!this.eq(leftValue, rightValue)) {
                    if (f == OverridesPackage.Literals.ITEM_OVERRIDES__LINK) {
                        itemOverrides.setNoLink(rightValue == null);
                    }
                    itemOverrides.eSet(f, rightValue);
                } else {
                    if (f == OverridesPackage.Literals.ITEM_OVERRIDES__LINK) {
                        itemOverrides.setNoLink(false);
                    }
                    itemOverrides.eUnset(f);
                }
                if (this.isEmpty(itemOverrides)) {
                    widgetOverrides.getItems().remove((Object)itemOverrides);
                }
            }
            if (this.isEmpty(widgetOverrides)) {
                overrides.getWidgets().remove((Object)widgetOverrides);
            }
            if (this.isEmpty(overrides)) {
                overrides = null;
            }
            this.updatedOverrides = overrides;
            return true;
        }

        private boolean isEmpty(WidgetOverrides widgetOverrides) {
            if (!this.isEmpty(widgetOverrides.getFont())) {
                return false;
            }
            return this.isEmptyFeatures(widgetOverrides);
        }

        private boolean isEmpty(ItemOverrides itemOverrides) {
            return this.isEmptyFeatures(itemOverrides);
        }

        private boolean isEmpty(FontOverrides fontOverrides) {
            return this.isEmptyFeatures(fontOverrides);
        }

        private boolean isEmpty(Overrides overrides) {
            return this.isEmptyFeatures(overrides);
        }

        private boolean isEmptyFeatures(EObject objectOverrides) {
            if (objectOverrides == null) {
                return true;
            }
            EList features = objectOverrides.eClass().getEAllStructuralFeatures();
            for (EStructuralFeature feature : features) {
                if (feature == OverridesPackage.Literals.REFERENCE__REF || !objectOverrides.eIsSet(feature)) continue;
                return false;
            }
            return true;
        }
    }
}

