/*
 * Decompiled with CFR 0.152.
 */
package com.wireframesketcher.model.util;

import com.wireframesketcher.model.ModelPackage;
import com.wireframesketcher.model.impl.ModelXMLResourceFactoryImpl;
import com.wireframesketcher.model.story.StoryPackage;
import com.wireframesketcher.model.util.ResourceURIHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Persister {
    private final ResourceSet resourceSet;
    private final Map<Object, Object> saveOptions = new HashMap<Object, Object>();

    public Persister() {
        this.resourceSet = new ResourceSetImpl();
        ResourceURIHandler uriHandler = new ResourceURIHandler();
        this.getLoadOptions().putAll(ModelXMLResourceFactoryImpl.DEFAULT_LOAD_SAVE_OPTIONS);
        this.getLoadOptions().putAll(ModelXMLResourceFactoryImpl.DEFAULT_LOAD_OPTIONS);
        this.getLoadOptions().put("URI_HANDLER", (Object)uriHandler);
        this.getSaveOptions().putAll(ModelXMLResourceFactoryImpl.DEFAULT_LOAD_SAVE_OPTIONS);
        this.getSaveOptions().putAll(ModelXMLResourceFactoryImpl.DEFAULT_SAVE_OPTIONS);
        this.getSaveOptions().put("URI_HANDLER", (Object)uriHandler);
        this.getSaveOptions().put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    private URI createLocalFileURI(File file) throws IOException {
        return URI.createFileURI((String)file.getCanonicalPath());
    }

    private void checkResource(EObject o) {
        if (o.eResource() == null) {
            URI uri = Persister.generateUniqueURI();
            Resource resource = this.resourceSet.createResource(uri);
            resource.getContents().add((Object)o);
        }
    }

    public void save(EObject o) throws IOException {
        this.checkResource(o);
        o.eResource().save(this.getSaveOptions());
    }

    public void save(EObject o, OutputStream out) throws IOException {
        this.checkResource(o);
        o.eResource().save(out, this.getSaveOptions());
    }

    public void save(EObject o, OutputStream out, URI uri) throws IOException {
        this.checkResource(o);
        o.eResource().setURI(uri);
        o.eResource().save(out, this.getSaveOptions());
    }

    public Map<Object, Object> getSaveOptions() {
        return this.saveOptions;
    }

    public EObject load(InputStream is) throws IOException {
        return this.load(is, null);
    }

    public EObject load(InputStream is, URI uri) throws IOException {
        URI loadURI = uri;
        if (loadURI == null) {
            loadURI = Persister.generateUniqueURI();
        }
        Resource resource = this.resourceSet.createResource(loadURI);
        try {
            resource.load(is, this.getLoadOptions());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.checkErrors(resource);
        return (EObject)resource.getContents().get(0);
    }

    private static URI generateUniqueURI() {
        return URI.createURI((String)(Persister.generateUniqueResourceName() + ".screen"));
    }

    private static String generateUniqueResourceName() {
        long a = Lazy.random.nextLong();
        a = a == Long.MIN_VALUE ? 0L : Math.abs(a);
        long b = System.currentTimeMillis();
        return "tmp-" + Long.toString(a) + '-' + Long.toString(b);
    }

    public Map<Object, Object> getLoadOptions() {
        return this.resourceSet.getLoadOptions();
    }

    public EObject load(File file) throws IOException {
        URI uri = this.createLocalFileURI(file);
        return this.load(uri);
    }

    public EObject load(URI uri) throws IOException {
        Resource resource = null;
        try {
            resource = this.getResourceSet().getResource(uri, true);
        }
        catch (WrappedException wrappedException) {
            // empty catch block
        }
        if (resource == null) {
            resource = this.getResourceSet().getResource(uri, true);
        }
        this.checkErrors(resource);
        return (EObject)resource.getContents().get(0);
    }

    protected void checkErrors(Resource resource) throws IOException {
        if (!resource.getErrors().isEmpty()) {
            Throwable exception = this.getDiagnosticException((EList<Resource.Diagnostic>)resource.getErrors());
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception != null) {
                throw new IOWrappedException(exception);
            }
            Diagnostic diagnostic = EcoreUtil.computeDiagnostic((Resource)resource, (boolean)false);
            throw new IOException(this.getDiagnosticMessage(diagnostic));
        }
    }

    private String getDiagnosticMessage(Diagnostic diagnostic) {
        String message = diagnostic.getMessage();
        if (message == null && !diagnostic.getChildren().isEmpty()) {
            List children = diagnostic.getChildren();
            for (int i = 0; i < children.size() && message == null; ++i) {
                message = this.getDiagnosticMessage((Diagnostic)children.get(i));
            }
        }
        return message;
    }

    private Throwable getDiagnosticException(EList<Resource.Diagnostic> errors) {
        for (Resource.Diagnostic error : errors) {
            if (!(error instanceof Throwable) || !(error instanceof WrappedException)) continue;
            return ((WrappedException)error).getCause();
        }
        return null;
    }

    static {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("screen", new ModelXMLResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("story", new ModelXMLResourceFactoryImpl());
        EPackage.Registry.INSTANCE.put((Object)"http://wireframesketcher.com/1.0/model.ecore", (Object)ModelPackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)"http://wireframesketcher.com/1.0/model/story", (Object)StoryPackage.eINSTANCE);
    }

    private static class IOWrappedException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public IOWrappedException(Throwable cause) {
            super(cause.getLocalizedMessage());
            this.initCause(cause);
        }
    }

    private static class Lazy {
        static SecureRandom random = new SecureRandom();

        private Lazy() {
        }
    }
}

