/*
 * Decompiled with CFR 0.152.
 */
package com.wireframesketcher.spy;

import com.wireframesketcher.model.Screen;
import com.wireframesketcher.model.util.Persister;
import com.wireframesketcher.spy.Converter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class SpyHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
            Screen screen = new Converter(shell).getScreen();
            String s = this.serializeScreen(screen);
            this.putToClipboard(shell.getDisplay(), s);
            MessageDialog.openInformation((Shell)shell, (String)"WireframeSketcher Spy", (String)("Window '" + shell.getText() + "' was exported to clipboard in XML format. Paste it directly into an existing screen."));
        }
        catch (Exception e) {
            throw new ExecutionException("Spy failed", (Throwable)e);
        }
        return null;
    }

    private void putToClipboard(Display display, String s) {
        Clipboard clipboard = new Clipboard(display);
        clipboard.setContents(new Object[]{s}, new Transfer[]{TextTransfer.getInstance()});
        clipboard.dispose();
    }

    private String serializeScreen(Screen screen) throws IOException {
        Persister persister = new Persister();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        persister.save((EObject)screen, (OutputStream)out);
        return new String(out.toByteArray(), "UTF-8");
    }
}

