/*
 * Decompiled with CFR 0.152.
 */
package com.wireframesketcher.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ButtonStyle implements Enumerator
{
    POINT_LEFT(0, "PointLeft", "pointleft"),
    SQUARE(1, "Square", "square"),
    ROUND(3, "Round", "round"),
    POINT_RIGHT(2, "PointRight", "pointright");

    public static final int POINT_LEFT_VALUE = 0;
    public static final int SQUARE_VALUE = 1;
    public static final int ROUND_VALUE = 3;
    public static final int POINT_RIGHT_VALUE = 2;
    private static final ButtonStyle[] VALUES_ARRAY;
    public static final List<ButtonStyle> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static ButtonStyle get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ButtonStyle result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static ButtonStyle getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ButtonStyle result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static ButtonStyle get(int value) {
        switch (value) {
            case 0: {
                return POINT_LEFT;
            }
            case 1: {
                return SQUARE;
            }
            case 3: {
                return ROUND;
            }
            case 2: {
                return POINT_RIGHT;
            }
        }
        return null;
    }

    private ButtonStyle(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new ButtonStyle[]{POINT_LEFT, SQUARE, ROUND, POINT_RIGHT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

