/*
 * Decompiled with CFR 0.152.
 */
package com.wireframesketcher.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ChartType implements Enumerator
{
    PIE(0, "Pie", "pie"),
    LINE(1, "Line", "line"),
    BAR(2, "Bar", "bar"),
    COLUMN(3, "Column", "column");

    public static final int PIE_VALUE = 0;
    public static final int LINE_VALUE = 1;
    public static final int BAR_VALUE = 2;
    public static final int COLUMN_VALUE = 3;
    private static final ChartType[] VALUES_ARRAY;
    public static final List<ChartType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static ChartType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ChartType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static ChartType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ChartType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static ChartType get(int value) {
        switch (value) {
            case 0: {
                return PIE;
            }
            case 1: {
                return LINE;
            }
            case 2: {
                return BAR;
            }
            case 3: {
                return COLUMN;
            }
        }
        return null;
    }

    private ChartType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new ChartType[]{PIE, LINE, BAR, COLUMN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

