/*
 * Decompiled with CFR 0.152.
 */
package com.wireframesketcher.model;

import java.util.HashMap;
import java.util.Map;

public final class ColorDesc {
    public static final ColorDesc white;
    public static final ColorDesc lightGray;
    public static final ColorDesc gray;
    public static final ColorDesc darkGray;
    public static final ColorDesc black;
    public static final ColorDesc red;
    public static final ColorDesc orange;
    public static final ColorDesc yellow;
    public static final ColorDesc green;
    public static final ColorDesc lightGreen;
    public static final ColorDesc darkGreen;
    public static final ColorDesc cyan;
    public static final ColorDesc lightBlue;
    public static final ColorDesc blue;
    public static final ColorDesc darkBlue;
    public static final Map<String, ColorDesc> namedColors;
    private final String name;
    private final int r;
    private final int g;
    private final int b;

    private static final void registerNamedColor(ColorDesc color) {
        namedColors.put(color.toString().toLowerCase(), color);
    }

    public ColorDesc(int r, int g, int b) {
        this(r, g, b, null);
    }

    public ColorDesc(int r, int g, int b, String name) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.name = name;
    }

    public int getRed() {
        return this.r;
    }

    public int getGreen() {
        return this.g;
    }

    public int getBlue() {
        return this.b;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ColorDesc)) {
            return false;
        }
        ColorDesc other = (ColorDesc)obj;
        return this.r == other.r && this.g == other.g && this.b == other.b;
    }

    public int hashCode() {
        return (this.r * 37 + this.g) * 37 + this.b;
    }

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        return this.toHexString();
    }

    public String toHexString() {
        String hex;
        if (this.r >> 4 == (this.r & 0xF) && this.g >> 4 == (this.g & 0xF) && this.b >> 4 == (this.b & 0xF)) {
            hex = Integer.toHexString((this.r & 0xF) << 8 | (this.g & 0xF) << 4 | this.b & 0xF).toLowerCase();
            if (hex.length() > 3) {
                hex = hex.substring(hex.length() - 3);
            } else if (hex.length() < 3) {
                hex = "000".substring(0, 3 - hex.length()) + hex;
            }
        } else {
            hex = Integer.toHexString(this.r << 16 | this.g << 8 | this.b).toLowerCase();
            if (hex.length() > 6) {
                hex = hex.substring(hex.length() - 6);
            } else if (hex.length() < 6) {
                hex = "000000".substring(0, 6 - hex.length()) + hex;
            }
        }
        return "#" + hex;
    }

    public static ColorDesc createFromString(String s) {
        ColorDesc color;
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        if ((s = s.toLowerCase()).startsWith("#")) {
            color = ColorDesc.createFromHexString(s.substring(1));
        } else {
            color = ColorDesc.createFromColorName(s);
            if (color == null) {
                color = ColorDesc.createFromHexString(s);
            }
        }
        return color;
    }

    private static ColorDesc createFromColorName(String s) {
        return namedColors.get(s);
    }

    private static ColorDesc createFromHexString(String s) {
        int hex;
        try {
            hex = Integer.parseInt(s, 16);
        }
        catch (NumberFormatException e) {
            return null;
        }
        if (s.length() == 3) {
            int r = hex >> 8 & 0xF | hex >> 4 & 0xF0;
            int g = hex >> 4 & 0xF | hex & 0xF0;
            int b = hex & 0xF | hex << 4 & 0xF0;
            return new ColorDesc(r, g, b);
        }
        if (s.length() == 6) {
            int r = hex >> 16 & 0xFF;
            int g = hex >> 8 & 0xFF;
            int b = hex & 0xFF;
            return new ColorDesc(r, g, b);
        }
        return null;
    }

    static {
        namedColors = new HashMap<String, ColorDesc>();
        black = new ColorDesc(0, 0, 0, "black");
        ColorDesc.registerNamedColor(black);
        ColorDesc.registerNamedColor(new ColorDesc(0, 0, 128, "navy"));
        darkBlue = new ColorDesc(0, 0, 139, "darkBlue");
        ColorDesc.registerNamedColor(darkBlue);
        ColorDesc.registerNamedColor(new ColorDesc(0, 0, 205, "mediumBlue"));
        blue = new ColorDesc(0, 0, 255, "blue");
        ColorDesc.registerNamedColor(blue);
        darkGreen = new ColorDesc(0, 100, 0, "darkGreen");
        ColorDesc.registerNamedColor(darkGreen);
        green = new ColorDesc(0, 128, 0, "green");
        ColorDesc.registerNamedColor(green);
        ColorDesc.registerNamedColor(new ColorDesc(0, 128, 128, "teal"));
        ColorDesc.registerNamedColor(new ColorDesc(0, 139, 139, "darkCyan"));
        ColorDesc.registerNamedColor(new ColorDesc(0, 191, 255, "deepSkyBlue"));
        ColorDesc.registerNamedColor(new ColorDesc(0, 206, 209, "darkTurquoise"));
        ColorDesc.registerNamedColor(new ColorDesc(0, 250, 154, "mediumSpringGreen"));
        ColorDesc.registerNamedColor(new ColorDesc(0, 255, 0, "lime"));
        ColorDesc.registerNamedColor(new ColorDesc(0, 255, 127, "springGreen"));
        ColorDesc.registerNamedColor(new ColorDesc(0, 255, 255, "aqua"));
        cyan = new ColorDesc(0, 255, 255, "cyan");
        ColorDesc.registerNamedColor(cyan);
        ColorDesc.registerNamedColor(new ColorDesc(25, 25, 112, "midnightBlue"));
        ColorDesc.registerNamedColor(new ColorDesc(30, 144, 255, "dodgerBlue"));
        ColorDesc.registerNamedColor(new ColorDesc(32, 178, 170, "lightSeaGreen"));
        ColorDesc.registerNamedColor(new ColorDesc(34, 139, 34, "forestGreen"));
        ColorDesc.registerNamedColor(new ColorDesc(46, 139, 87, "seaGreen"));
        ColorDesc.registerNamedColor(new ColorDesc(47, 79, 79, "darkSlateGray"));
        ColorDesc.registerNamedColor(new ColorDesc(50, 205, 50, "limeGreen"));
        ColorDesc.registerNamedColor(new ColorDesc(60, 179, 113, "mediumSeaGreen"));
        ColorDesc.registerNamedColor(new ColorDesc(64, 224, 208, "turquoise"));
        ColorDesc.registerNamedColor(new ColorDesc(65, 105, 225, "royalBlue"));
        ColorDesc.registerNamedColor(new ColorDesc(70, 130, 180, "steelBlue"));
        ColorDesc.registerNamedColor(new ColorDesc(72, 61, 139, "darkSlateBlue"));
        ColorDesc.registerNamedColor(new ColorDesc(72, 209, 204, "mediumTurquoise"));
        ColorDesc.registerNamedColor(new ColorDesc(75, 0, 130, "indigo"));
        ColorDesc.registerNamedColor(new ColorDesc(85, 107, 47, "darkOliveGreen"));
        ColorDesc.registerNamedColor(new ColorDesc(95, 158, 160, "cadetBlue"));
        ColorDesc.registerNamedColor(new ColorDesc(100, 149, 237, "cornflowerBlue"));
        ColorDesc.registerNamedColor(new ColorDesc(102, 205, 170, "mediumAquaMarine"));
        ColorDesc.registerNamedColor(new ColorDesc(105, 105, 105, "dimGray"));
        ColorDesc.registerNamedColor(new ColorDesc(105, 105, 105, "dimGrey"));
        ColorDesc.registerNamedColor(new ColorDesc(106, 90, 205, "slateBlue"));
        ColorDesc.registerNamedColor(new ColorDesc(107, 142, 35, "oliveDrab"));
        ColorDesc.registerNamedColor(new ColorDesc(112, 128, 144, "slateGray"));
        ColorDesc.registerNamedColor(new ColorDesc(119, 136, 153, "lightSlateGray"));
        ColorDesc.registerNamedColor(new ColorDesc(123, 104, 238, "mediumSlateBlue"));
        ColorDesc.registerNamedColor(new ColorDesc(124, 252, 0, "lawnGreen"));
        ColorDesc.registerNamedColor(new ColorDesc(127, 255, 0, "chartreuse"));
        ColorDesc.registerNamedColor(new ColorDesc(127, 255, 212, "aquamarine"));
        ColorDesc.registerNamedColor(new ColorDesc(128, 0, 0, "maroon"));
        ColorDesc.registerNamedColor(new ColorDesc(128, 0, 128, "purple"));
        ColorDesc.registerNamedColor(new ColorDesc(128, 128, 0, "olive"));
        gray = new ColorDesc(128, 128, 128, "gray");
        ColorDesc.registerNamedColor(gray);
        ColorDesc.registerNamedColor(new ColorDesc(135, 206, 235, "skyBlue"));
        ColorDesc.registerNamedColor(new ColorDesc(135, 206, 250, "lightSkyBlue"));
        ColorDesc.registerNamedColor(new ColorDesc(138, 43, 226, "blueViolet"));
        ColorDesc.registerNamedColor(new ColorDesc(139, 0, 0, "darkRed"));
        ColorDesc.registerNamedColor(new ColorDesc(139, 0, 139, "darkMagenta"));
        ColorDesc.registerNamedColor(new ColorDesc(139, 69, 19, "saddleBrown"));
        ColorDesc.registerNamedColor(new ColorDesc(143, 188, 143, "darkSeaGreen"));
        lightGreen = new ColorDesc(144, 238, 144, "lightGreen");
        ColorDesc.registerNamedColor(lightGreen);
        ColorDesc.registerNamedColor(new ColorDesc(147, 112, 219, "mediumPurple"));
        ColorDesc.registerNamedColor(new ColorDesc(148, 0, 211, "darkViolet"));
        ColorDesc.registerNamedColor(new ColorDesc(152, 251, 152, "paleGreen"));
        ColorDesc.registerNamedColor(new ColorDesc(153, 50, 204, "darkOrchid"));
        ColorDesc.registerNamedColor(new ColorDesc(154, 205, 50, "yellowGreen"));
        ColorDesc.registerNamedColor(new ColorDesc(160, 82, 45, "sienna"));
        ColorDesc.registerNamedColor(new ColorDesc(165, 42, 42, "brown"));
        darkGray = new ColorDesc(169, 169, 169, "darkGray");
        ColorDesc.registerNamedColor(darkGray);
        lightBlue = new ColorDesc(173, 216, 230, "lightBlue");
        ColorDesc.registerNamedColor(lightBlue);
        ColorDesc.registerNamedColor(new ColorDesc(173, 255, 47, "greenYellow"));
        ColorDesc.registerNamedColor(new ColorDesc(175, 238, 238, "paleTurquoise"));
        ColorDesc.registerNamedColor(new ColorDesc(176, 196, 222, "lightSteelBlue"));
        ColorDesc.registerNamedColor(new ColorDesc(176, 224, 230, "powderBlue"));
        ColorDesc.registerNamedColor(new ColorDesc(178, 34, 34, "fireBrick"));
        ColorDesc.registerNamedColor(new ColorDesc(184, 134, 11, "darkGoldenRod"));
        ColorDesc.registerNamedColor(new ColorDesc(186, 85, 211, "mediumOrchid"));
        ColorDesc.registerNamedColor(new ColorDesc(188, 143, 143, "rosyBrown"));
        ColorDesc.registerNamedColor(new ColorDesc(189, 183, 107, "darkKhaki"));
        ColorDesc.registerNamedColor(new ColorDesc(192, 192, 192, "silver"));
        ColorDesc.registerNamedColor(new ColorDesc(199, 21, 133, "mediumVioletRed"));
        ColorDesc.registerNamedColor(new ColorDesc(205, 92, 92, "indianRed"));
        ColorDesc.registerNamedColor(new ColorDesc(205, 133, 63, "peru"));
        ColorDesc.registerNamedColor(new ColorDesc(210, 105, 30, "chocolate"));
        ColorDesc.registerNamedColor(new ColorDesc(210, 180, 140, "tan"));
        lightGray = new ColorDesc(211, 211, 211, "lightGray");
        ColorDesc.registerNamedColor(lightGray);
        ColorDesc.registerNamedColor(new ColorDesc(216, 191, 216, "thistle"));
        ColorDesc.registerNamedColor(new ColorDesc(218, 112, 214, "orchid"));
        ColorDesc.registerNamedColor(new ColorDesc(218, 165, 32, "goldenRod"));
        ColorDesc.registerNamedColor(new ColorDesc(219, 112, 147, "paleVioletRed"));
        ColorDesc.registerNamedColor(new ColorDesc(220, 20, 60, "crimson"));
        ColorDesc.registerNamedColor(new ColorDesc(220, 220, 220, "gainsboro"));
        ColorDesc.registerNamedColor(new ColorDesc(221, 160, 221, "plum"));
        ColorDesc.registerNamedColor(new ColorDesc(222, 184, 135, "burlyWood"));
        ColorDesc.registerNamedColor(new ColorDesc(224, 255, 255, "lightCyan"));
        ColorDesc.registerNamedColor(new ColorDesc(230, 230, 250, "lavender"));
        ColorDesc.registerNamedColor(new ColorDesc(233, 150, 122, "darkSalmon"));
        ColorDesc.registerNamedColor(new ColorDesc(238, 130, 238, "violet"));
        ColorDesc.registerNamedColor(new ColorDesc(238, 232, 170, "paleGoldenRod"));
        ColorDesc.registerNamedColor(new ColorDesc(240, 128, 128, "lightCoral"));
        ColorDesc.registerNamedColor(new ColorDesc(240, 230, 140, "khaki"));
        ColorDesc.registerNamedColor(new ColorDesc(240, 248, 255, "aliceBlue"));
        ColorDesc.registerNamedColor(new ColorDesc(240, 255, 240, "honeyDew"));
        ColorDesc.registerNamedColor(new ColorDesc(240, 255, 255, "azure"));
        ColorDesc.registerNamedColor(new ColorDesc(244, 164, 96, "sandyBrown"));
        ColorDesc.registerNamedColor(new ColorDesc(245, 222, 179, "wheat"));
        ColorDesc.registerNamedColor(new ColorDesc(245, 245, 220, "beige"));
        ColorDesc.registerNamedColor(new ColorDesc(245, 245, 245, "whiteSmoke"));
        ColorDesc.registerNamedColor(new ColorDesc(245, 255, 250, "mintCream"));
        ColorDesc.registerNamedColor(new ColorDesc(248, 248, 255, "ghostWhite"));
        ColorDesc.registerNamedColor(new ColorDesc(250, 128, 114, "salmon"));
        ColorDesc.registerNamedColor(new ColorDesc(250, 235, 215, "antiqueWhite"));
        ColorDesc.registerNamedColor(new ColorDesc(250, 240, 230, "linen"));
        ColorDesc.registerNamedColor(new ColorDesc(250, 250, 210, "lightGoldenRodYellow"));
        ColorDesc.registerNamedColor(new ColorDesc(253, 245, 230, "oldLace"));
        red = new ColorDesc(255, 0, 0, "red");
        ColorDesc.registerNamedColor(red);
        ColorDesc.registerNamedColor(new ColorDesc(255, 0, 255, "fuchsia"));
        ColorDesc.registerNamedColor(new ColorDesc(255, 0, 255, "magenta"));
        ColorDesc.registerNamedColor(new ColorDesc(255, 20, 147, "deepPink"));
        ColorDesc.registerNamedColor(new ColorDesc(255, 69, 0, "orangeRed"));
        ColorDesc.registerNamedColor(new ColorDesc(255, 99, 71, "tomato"));
        ColorDesc.registerNamedColor(new ColorDesc(255, 105, 180, "hotPink"));
        ColorDesc.registerNamedColor(new ColorDesc(255, 127, 80, "coral"));
        ColorDesc.registerNamedColor(new ColorDesc(255, 140, 0, "darkorange"));
        ColorDesc.registerNamedColor(new ColorDesc(255, 160, 122, "lightSalmon"));
        orange = new ColorDesc(255, 165, 0, "orange");
        ColorDesc.registerNamedColor(orange);
        ColorDesc.registerNamedColor(new ColorDesc(255, 182, 193, "lightPink"));
        ColorDesc.registerNamedColor(new ColorDesc(255, 192, 203, "pink"));
        ColorDesc.registerNamedColor(new ColorDesc(255, 215, 0, "gold"));
        ColorDesc.registerNamedColor(new ColorDesc(255, 218, 185, "peachPuff"));
        ColorDesc.registerNamedColor(new ColorDesc(255, 222, 173, "navajoWhite"));
        ColorDesc.registerNamedColor(new ColorDesc(255, 228, 181, "moccasin"));
        ColorDesc.registerNamedColor(new ColorDesc(255, 228, 196, "bisque"));
        ColorDesc.registerNamedColor(new ColorDesc(255, 228, 225, "mistyRose"));
        ColorDesc.registerNamedColor(new ColorDesc(255, 235, 205, "blanchedAlmond"));
        ColorDesc.registerNamedColor(new ColorDesc(255, 239, 213, "papayaWhip"));
        ColorDesc.registerNamedColor(new ColorDesc(255, 240, 245, "lavenderBlush"));
        ColorDesc.registerNamedColor(new ColorDesc(255, 245, 238, "seaShell"));
        ColorDesc.registerNamedColor(new ColorDesc(255, 248, 220, "cornsilk"));
        ColorDesc.registerNamedColor(new ColorDesc(255, 250, 205, "lemonChiffon"));
        ColorDesc.registerNamedColor(new ColorDesc(255, 250, 240, "floralWhite"));
        ColorDesc.registerNamedColor(new ColorDesc(255, 250, 250, "snow"));
        yellow = new ColorDesc(255, 255, 0, "yellow");
        ColorDesc.registerNamedColor(yellow);
        ColorDesc.registerNamedColor(new ColorDesc(255, 255, 224, "lightYellow"));
        ColorDesc.registerNamedColor(new ColorDesc(255, 255, 240, "ivory"));
        white = new ColorDesc(255, 255, 255, "white");
        ColorDesc.registerNamedColor(white);
    }
}

