/*
 * Decompiled with CFR 0.152.
 */
package com.wireframesketcher.model;

public final class FontSize {
    private final int size;
    private final Unit unit;

    private FontSize(int size, Unit unit) {
        if (unit == null) {
            throw new NullPointerException();
        }
        this.size = size;
        this.unit = unit;
    }

    public int getSize() {
        return this.size;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public String toString() {
        return Integer.toString(this.size) + this.unit.suffix;
    }

    public String toString(Unit defaultUnit) {
        if (defaultUnit == this.unit) {
            return Integer.toString(this.size);
        }
        return Integer.toString(this.size) + this.unit.suffix;
    }

    public static FontSize createFromString(String s) throws NumberFormatException {
        return FontSize.createFromString(s, Unit.POINTS);
    }

    public static FontSize createFromString(String s, Unit defaultUnit) throws NumberFormatException {
        int size;
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        Unit unit = defaultUnit;
        Unit[] units = Unit.ALL;
        for (int i = 0; i < units.length; ++i) {
            Unit u = units[i];
            if (!s.endsWith(u.suffix)) continue;
            unit = u;
            s = s.substring(0, s.length() - u.suffix.length());
            break;
        }
        try {
            size = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Invalid font size format: " + s);
        }
        return new FontSize(size, unit);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FontSize)) {
            return false;
        }
        FontSize other = (FontSize)obj;
        return this.size == other.size && this.unit == other.unit;
    }

    public int hashCode() {
        return this.size * 37 + this.unit.hashCode();
    }

    public static FontSize inPixels(int size) {
        return new FontSize(size, Unit.PIXELS);
    }

    public static FontSize inPoints(int size) {
        return new FontSize(size, Unit.POINTS);
    }

    public int toIntPoints(int dpi) {
        if (this.unit == Unit.POINTS || dpi == 72) {
            return this.size;
        }
        return Math.round((float)this.size * 72.0f / (float)dpi);
    }

    public FontSize toPoints(int dpi) {
        if (this.unit == Unit.POINTS) {
            return this;
        }
        return FontSize.inPoints(this.toIntPoints(dpi));
    }

    public int toIntPixels(int dpi) {
        if (this.unit == Unit.PIXELS || dpi == 72) {
            return this.size;
        }
        return Math.round((float)(this.size * dpi) / 72.0f);
    }

    public FontSize toPixels(int dpi) {
        if (this.unit == Unit.PIXELS) {
            return this;
        }
        return FontSize.inPixels(this.toIntPixels(dpi));
    }

    public FontSize toSize(int newSize) {
        if (newSize == this.size) {
            return this;
        }
        return new FontSize(newSize, this.unit);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Unit {
        PIXELS("px"),
        POINTS("pt");

        static Unit[] ALL;
        private final String suffix;

        private Unit(String suffix) {
            if (suffix == null) {
                throw new NullPointerException();
            }
            this.suffix = suffix;
        }

        static {
            ALL = new Unit[]{PIXELS, POINTS};
        }
    }
}

