/*
 * Decompiled with CFR 0.152.
 */
package com.wireframesketcher.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum IconSize implements Enumerator
{
    SMALL_LITERAL(0, "Small", "small"),
    MEDIUM_LITERAL(1, "Medium", "medium"),
    LARGE_LITERAL(2, "Large", "large"),
    XLARGE_LITERAL(3, "XLarge", "xlarge"),
    XXL_LITERAL(4, "XXL", "xxl"),
    CUSTOM_LITERAL(5, "Custom", "custom");

    public static final int SMALL = 0;
    public static final int MEDIUM = 1;
    public static final int LARGE = 2;
    public static final int XLARGE = 3;
    public static final int XXL = 4;
    public static final int CUSTOM = 5;
    private static final IconSize[] VALUES_ARRAY;
    public static final List<IconSize> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static IconSize get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            IconSize result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static IconSize getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            IconSize result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static IconSize get(int value) {
        switch (value) {
            case 0: {
                return SMALL_LITERAL;
            }
            case 1: {
                return MEDIUM_LITERAL;
            }
            case 2: {
                return LARGE_LITERAL;
            }
            case 3: {
                return XLARGE_LITERAL;
            }
            case 4: {
                return XXL_LITERAL;
            }
            case 5: {
                return CUSTOM_LITERAL;
            }
        }
        return null;
    }

    private IconSize(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    public int getSizePixels() {
        return IconSize.getSizePixels(this);
    }

    public static int getSizePixels(IconSize size) {
        switch (size.getValue()) {
            case 0: {
                return 16;
            }
            case 1: {
                return 24;
            }
            case 2: {
                return 32;
            }
            case 3: {
                return 48;
            }
            case 4: {
                return 128;
            }
            case 5: {
                return -1;
            }
        }
        throw new IllegalArgumentException(size.toString());
    }

    static {
        VALUES_ARRAY = new IconSize[]{SMALL_LITERAL, MEDIUM_LITERAL, LARGE_LITERAL, XLARGE_LITERAL, XXL_LITERAL, CUSTOM_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

