/*
 * Decompiled with CFR 0.152.
 */
package com.wireframesketcher.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ShapeType implements Enumerator
{
    ELLIPSE(0, "Ellipse", "ellipse"),
    RECTANGLE(1, "Rectangle", "rectangle"),
    ROUNDED_RECTANGLE(2, "RoundedRectangle", "rectangle-rounded"),
    ROUND_RECTANGLE(3, "RoundRectangle", "rectangle-round"),
    DIAMOND(4, "Diamond", "diamond"),
    STAR(5, "Star", "star"),
    PARALLELOGRAM(6, "Parallelogram", "parallelogram"),
    TRIANGLE(7, "Triangle", "triangle"),
    RIGHT_TRIANGLE(8, "RightTriangle", "triangle-right");

    public static final int ELLIPSE_VALUE = 0;
    public static final int RECTANGLE_VALUE = 1;
    public static final int ROUNDED_RECTANGLE_VALUE = 2;
    public static final int ROUND_RECTANGLE_VALUE = 3;
    public static final int DIAMOND_VALUE = 4;
    public static final int STAR_VALUE = 5;
    public static final int PARALLELOGRAM_VALUE = 6;
    public static final int TRIANGLE_VALUE = 7;
    public static final int RIGHT_TRIANGLE_VALUE = 8;
    private static final ShapeType[] VALUES_ARRAY;
    public static final List<ShapeType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static ShapeType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ShapeType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static ShapeType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ShapeType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static ShapeType get(int value) {
        switch (value) {
            case 0: {
                return ELLIPSE;
            }
            case 1: {
                return RECTANGLE;
            }
            case 2: {
                return ROUNDED_RECTANGLE;
            }
            case 3: {
                return ROUND_RECTANGLE;
            }
            case 4: {
                return DIAMOND;
            }
            case 5: {
                return STAR;
            }
            case 6: {
                return PARALLELOGRAM;
            }
            case 7: {
                return TRIANGLE;
            }
            case 8: {
                return RIGHT_TRIANGLE;
            }
        }
        return null;
    }

    private ShapeType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new ShapeType[]{ELLIPSE, RECTANGLE, ROUNDED_RECTANGLE, ROUND_RECTANGLE, DIAMOND, STAR, PARALLELOGRAM, TRIANGLE, RIGHT_TRIANGLE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

