/*
 * Decompiled with CFR 0.152.
 */
package com.wireframesketcher.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TextAlignment implements Enumerator
{
    LEFT_LITERAL(0, "Left", "Left"),
    CENTER_LITERAL(1, "Center", "Center"),
    RIGHT_LITERAL(2, "Right", "Right");

    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    private static final TextAlignment[] VALUES_ARRAY;
    public static final List<TextAlignment> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static TextAlignment get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            TextAlignment result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static TextAlignment getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            TextAlignment result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static TextAlignment get(int value) {
        switch (value) {
            case 0: {
                return LEFT_LITERAL;
            }
            case 1: {
                return CENTER_LITERAL;
            }
            case 2: {
                return RIGHT_LITERAL;
            }
        }
        return null;
    }

    private TextAlignment(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new TextAlignment[]{LEFT_LITERAL, CENTER_LITERAL, RIGHT_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

