/*
 * Decompiled with CFR 0.152.
 */
package com.wireframesketcher.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Theme implements Enumerator
{
    DEFAULT(0, "Default", "default"),
    CLEAN(1, "Clean", "clean"),
    SKETCH(2, "Sketch", "sketch");

    public static final int DEFAULT_VALUE = 0;
    public static final int CLEAN_VALUE = 1;
    public static final int SKETCH_VALUE = 2;
    private static final Theme[] VALUES_ARRAY;
    public static final List<Theme> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static Theme get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            Theme result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static Theme getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            Theme result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static Theme get(int value) {
        switch (value) {
            case 0: {
                return DEFAULT;
            }
            case 1: {
                return CLEAN;
            }
            case 2: {
                return SKETCH;
            }
        }
        return null;
    }

    private Theme(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new Theme[]{DEFAULT, CLEAN, SKETCH};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

