/*
 * Decompiled with CFR 0.152.
 */
package com.wireframesketcher.model.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Diff {
    public static final Comparator<Object> EQUALITY_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            return o1.equals(o2) ? 0 : 1;
        }
    };
    private static final Edit[] EMPTY = new Edit[0];

    Diff() {
    }

    public static <T> Edit[] diffWithMoves(T[] a, T[] b, Comparator<? super T> comparator) {
        List<Edit> result = Diff.basicDiff(a, b, comparator);
        result = Diff.calculateMoves(a, b, comparator, result);
        return Diff.convertResult(result);
    }

    public static <T> Edit[] diff(T[] a, T[] b, Comparator<? super T> comparator) {
        List<Edit> result = Diff.basicDiff(a, b, comparator);
        return Diff.convertResult(result);
    }

    private static Edit[] convertResult(List<Edit> result) {
        if (result == null || result.isEmpty()) {
            return EMPTY;
        }
        return result.toArray(new Edit[result.size()]);
    }

    private static <T> List<Edit> calculateMoves(T[] a, T[] b, Comparator<? super T> comparator, List<Edit> result) {
        if (result == null || result.size() < 2) {
            return result;
        }
        boolean[] processed = new boolean[result.size()];
        ArrayList<Edit> moves = new ArrayList<Edit>(result.size());
        int delta = 0;
        for (int k = 0; k < result.size(); ++k) {
            Edit c1;
            int i;
            int tmpDelta;
            Edit c0 = result.get(k);
            if (processed[k]) {
                if (c0.type == EditType.DELETE) {
                    ++delta;
                    continue;
                }
                --delta;
                continue;
            }
            if (c0.type == EditType.DELETE) {
                T deleted = a[c0.index0];
                tmpDelta = delta;
                for (i = k + 1; i < result.size(); ++i) {
                    c1 = result.get(i);
                    if (processed[i]) {
                        if (c1.type == EditType.DELETE) {
                            ++tmpDelta;
                            continue;
                        }
                        --tmpDelta;
                        continue;
                    }
                    if (c1.type != EditType.INSERT || comparator.compare(deleted, b[c1.index1]) != 0) continue;
                    processed[i] = true;
                    processed[k] = true;
                    moves.add(Edit.move(delta + c0.index0, tmpDelta + c1.index0));
                    ++delta;
                    break;
                }
            } else if (c0.type == EditType.INSERT) {
                T inserted = b[c0.index1];
                tmpDelta = delta;
                for (i = k + 1; i < result.size(); ++i) {
                    c1 = result.get(i);
                    if (processed[i]) {
                        if (c1.type == EditType.DELETE) {
                            ++tmpDelta;
                            continue;
                        }
                        --tmpDelta;
                        continue;
                    }
                    if (c1.type != EditType.DELETE || comparator.compare(a[c1.index0], inserted) != 0) continue;
                    processed[i] = true;
                    processed[k] = true;
                    moves.add(Edit.move(tmpDelta + c1.index0, delta + c0.index0));
                    --delta;
                    break;
                }
            }
            if (processed[k]) continue;
            if (delta == 0) {
                moves.add(c0);
                continue;
            }
            moves.add(new Edit(c0.type, delta + c0.index0, c0.index1));
        }
        return moves;
    }

    private static <T> List<Edit> basicDiff(T[] a, T[] b, Comparator<? super T> comparator) {
        int j;
        int i;
        int[][] m = new int[a.length + 1][b.length + 1];
        for (i = 1; i <= a.length; ++i) {
            for (j = 1; j <= b.length; ++j) {
                m[i][j] = comparator.compare(a[i - 1], b[j - 1]) == 0 ? 1 + m[i - 1][j - 1] : Math.max(m[i - 1][j], m[i][j - 1]);
            }
        }
        i = a.length;
        j = b.length;
        ArrayList<Edit> result = new ArrayList<Edit>(Math.max(a.length, b.length) + 1);
        while (i != 0 && j != 0) {
            if (comparator.compare(a[i - 1], b[j - 1]) == 0) {
                --i;
                --j;
                continue;
            }
            if (m[i][j - 1] >= m[i - 1][j]) {
                result.add(Edit.insert(i, --j));
                continue;
            }
            result.add(Edit.delete(--i, j));
        }
        while (j != 0) {
            result.add(Edit.insert(i, --j));
        }
        while (i != 0) {
            result.add(Edit.delete(--i, j));
        }
        return result;
    }

    public static class Edit {
        public final EditType type;
        public final int index0;
        public final int index1;

        Edit(EditType type, int index0, int index1) {
            this.type = type;
            this.index0 = index0;
            this.index1 = index1;
        }

        public String toString() {
            return "[" + (Object)((Object)this.type) + ", " + this.index0 + ", " + this.index1 + "]";
        }

        public boolean equals(Object obj) {
            Edit other = (Edit)obj;
            return this.type.equals((Object)other.type) && this.index0 == other.index0 && this.index1 == other.index1;
        }

        public static Edit insert(int index0, int index1) {
            return new Edit(EditType.INSERT, index0, index1);
        }

        public static Edit delete(int index0, int index1) {
            return new Edit(EditType.DELETE, index0, index1);
        }

        public static Edit move(int index0, int index1) {
            return new Edit(EditType.MOVE, index0, index1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EditType {
        INSERT,
        DELETE,
        MOVE;

    }
}

