/*
 * Decompiled with CFR 0.152.
 */
package com.wireframesketcher.model.impl;

import com.wireframesketcher.model.Master;
import com.wireframesketcher.model.ModelResource;
import com.wireframesketcher.model.NameSupport;
import com.wireframesketcher.model.Screen;
import com.wireframesketcher.model.Widget;
import com.wireframesketcher.model.impl.ModelXMLHelperImpl;
import com.wireframesketcher.model.overrides.Insert;
import com.wireframesketcher.model.overrides.Operation;
import com.wireframesketcher.model.overrides.Overrides;
import com.wireframesketcher.model.overrides.OverridesPackage;
import com.wireframesketcher.model.overrides.WidgetContainerOverrides;
import com.wireframesketcher.model.overrides.WidgetOverrides;
import com.wireframesketcher.model.story.Panel;
import com.wireframesketcher.model.story.impl.PanelImpl;
import com.wireframesketcher.model.util.WidgetTreeIterator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelXMLResourceImpl
extends XMLResourceImpl
implements ModelResource {
    private long maxWidgetId;

    public ModelXMLResourceImpl() {
    }

    public ModelXMLResourceImpl(URI uri) {
        super(uri);
    }

    protected void init() {
        super.init();
        this.setIntrinsicIDToEObjectMap(new HashMap());
    }

    protected XMLHelper createXMLHelper() {
        return new ModelXMLHelperImpl(this);
    }

    public String getURIFragment(EObject object) {
        String name;
        if (object instanceof NameSupport && (name = ((NameSupport)object).getName()) != null) {
            return URI.encodeFragment((String)name, (boolean)false);
        }
        return super.getURIFragment(object);
    }

    @Override
    public String getDefaultURIFragment(EObject object) {
        return super.getURIFragment(object);
    }

    public EObject getEObject(String uriFragment) {
        EList contents = this.getContents();
        String name = URI.decode((String)uriFragment);
        for (int i = 0; i < contents.size(); ++i) {
            EObject root = (EObject)contents.get(i);
            EList children = root.eContents();
            for (int j = 0; j < children.size(); ++j) {
                EObject child = (EObject)children.get(j);
                if (!(child instanceof NameSupport) || !name.equals(((NameSupport)child).getName())) continue;
                return child;
            }
        }
        return super.getEObject(uriFragment);
    }

    protected void doUnload() {
        super.doUnload();
        this.getIntrinsicIDToEObjectMap().clear();
    }

    protected void attachedHelper(EObject eObject) {
        Panel panel;
        String id;
        if (eObject instanceof Widget) {
            Widget widget = (Widget)eObject;
            Long id2 = widget.getId();
            if (id2 == null && !this.isLoading() && this.isDirectWidget(widget)) {
                this.assignWidgetId(widget);
            }
        } else if (eObject instanceof Panel && (id = (panel = (Panel)eObject).getId()) == null) {
            this.assignPanelId(panel);
        }
        super.attachedHelper(eObject);
    }

    private void assignPanelId(Panel panel) {
        panel.setId(this.generatePanelId(panel));
    }

    private String generatePanelId(Panel panel) {
        return PanelUUID.generateUUID(this, panel);
    }

    private void assignWidgetId(Widget widget) {
        widget.setId(this.generateNextWidgetId());
    }

    private Long generateNextWidgetId() {
        return ++this.maxWidgetId;
    }

    public void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
        this.assignMissingIds();
        super.doSave(outputStream, options);
    }

    public void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        super.doLoad(inputStream, options);
        this.maxWidgetId = this.computeMaxWidgetId();
    }

    private long computeMaxWidgetId() {
        long maxId = 0L;
        WidgetTreeIterator i = this.getAllDirectWidgets();
        while (i.hasNext()) {
            Widget widget = (Widget)i.next();
            Long id = widget.getId();
            if (id == null) continue;
            maxId = Math.max(maxId, id);
        }
        return maxId;
    }

    private WidgetTreeIterator getAllDirectWidgets() {
        EList contents = this.getContents();
        return new DirectWidgetsIterator(contents.isEmpty() ? null : (EObject)contents.get(0));
    }

    private void assignMissingIds() {
        WidgetTreeIterator i = this.getAllDirectWidgets();
        while (i.hasNext()) {
            Widget widget = (Widget)i.next();
            if (widget.getId() != null) continue;
            this.assignWidgetId(widget);
        }
    }

    private boolean isDirectWidget(Widget widget) {
        Widget object = widget;
        boolean insertedObject = false;
        while (object != null && !(object instanceof Screen)) {
            if ((object = object.eContainer()) instanceof Insert) {
                insertedObject = true;
                continue;
            }
            if (!(object instanceof Master) || insertedObject) continue;
            return false;
        }
        return object instanceof Screen && this.getContents().contains((Object)object);
    }

    private static class Base64 {
        private static final char[] BYTE_TO_BASE64 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '_'};
        private static final char PAD_CHAR = '=';

        private Base64() {
        }

        public static String encode(byte[] bytes) {
            int b1;
            int b0;
            if (bytes == null) {
                return null;
            }
            StringBuilder buffer = new StringBuilder(4 * ((bytes.length + 2) / 3));
            int i = 0;
            while (i + 2 < bytes.length) {
                b0 = bytes[i++] & 0xFF;
                b1 = bytes[i++] & 0xFF;
                int b2 = bytes[i++] & 0xFF;
                buffer.append(BYTE_TO_BASE64[b0 >> 2]);
                buffer.append(BYTE_TO_BASE64[b0 << 4 & 0x3F | b1 >> 4]);
                buffer.append(BYTE_TO_BASE64[b1 << 2 & 0x3F | b2 >> 6]);
                buffer.append(BYTE_TO_BASE64[b2 & 0x3F]);
            }
            if (i + 1 == bytes.length) {
                b0 = bytes[i++] & 0xFF;
                buffer.append(BYTE_TO_BASE64[b0 >> 2]);
                buffer.append(BYTE_TO_BASE64[b0 << 4 & 0x3F]);
                buffer.append('=');
                buffer.append('=');
            } else if (i + 2 == bytes.length) {
                b0 = bytes[i++] & 0xFF;
                b1 = bytes[i++] & 0xFF;
                buffer.append(BYTE_TO_BASE64[b0 >> 2]);
                buffer.append(BYTE_TO_BASE64[b0 << 4 & 0x3F | b1 >> 4]);
                buffer.append(BYTE_TO_BASE64[b1 << 2 & 0x3F]);
                buffer.append('=');
            }
            return buffer.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class DirectWidgetsIterator
    extends WidgetTreeIterator {
        public DirectWidgetsIterator(Object object) {
            super(object, true);
        }

        @Override
        protected Iterator<? extends Widget> getComponentChildren(Master master) {
            Overrides overrides = master.getOverrides();
            if (overrides != null) {
                BasicEList children = new BasicEList();
                if (overrides.eIsSet((EStructuralFeature)OverridesPackage.Literals.OVERRIDES__WIDGETS)) {
                    EList<WidgetOverrides> widgets = overrides.getWidgets();
                    int jSz = widgets.size();
                    for (int j = 0; j < jSz; ++j) {
                        WidgetContainerOverrides widgetOverrides = (WidgetContainerOverrides)widgets.get(j);
                        this.collectInsertedWidgets(widgetOverrides, (List<Widget>)children);
                    }
                }
                this.collectInsertedWidgets(overrides, (List<Widget>)children);
                if (!children.isEmpty()) {
                    return children.iterator();
                }
            }
            return ECollections.emptyEList().iterator();
        }

        private void collectInsertedWidgets(WidgetContainerOverrides widgetOverrides, List<Widget> widgets) {
            if (widgetOverrides.eIsSet((EStructuralFeature)OverridesPackage.Literals.WIDGET_CONTAINER_OVERRIDES__WIDGET_CHANGES)) {
                EList<Operation> changes = widgetOverrides.getWidgetChanges();
                int sz = changes.size();
                for (int i = 0; i < sz; ++i) {
                    Insert insert;
                    EObject object;
                    Operation operation = (Operation)changes.get(i);
                    if (!(operation instanceof Insert) || !((object = (insert = (Insert)operation).getObject()) instanceof Widget)) continue;
                    widgets.add((Widget)object);
                }
            }
        }
    }

    private static class PanelUUID {
        private PanelUUID() {
        }

        public static String generateUUID(ModelXMLResourceImpl resource, Panel panel) {
            String id;
            int counter = 0;
            try {
                do {
                    id = PanelUUID.generateUUID(panel, counter++);
                    ++counter;
                } while (resource.getIntrinsicIDToEObjectMap().get(id) != null);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            return id;
        }

        private static String generateUUID(Panel panel, int sequence) throws NoSuchAlgorithmException, UnsupportedEncodingException {
            URI panelURI;
            MessageDigest sig = MessageDigest.getInstance("SHA-1");
            URI storyURI = PanelUUID.getStoryURI(panel);
            if (storyURI != null) {
                sig.update(storyURI.toString().getBytes("UTF-8"));
            }
            if ((panelURI = PanelUUID.getPanelURI(panel)) != null) {
                sig.update(panelURI.toString().getBytes("UTF-8"));
            }
            sig.update((byte)(sequence >> 24 & 0xFF));
            sig.update((byte)(sequence >> 16 & 0xFF));
            sig.update((byte)(sequence >> 8 & 0xFF));
            sig.update((byte)(sequence & 0xFF));
            byte[] bytes = sig.digest();
            return Base64.encode(bytes);
        }

        private static URI getPanelURI(Panel panel) {
            Object ref = ((PanelImpl)panel).basicGetScreen();
            if (ref == null) {
                ref = ((PanelImpl)panel).basicGetStory();
            }
            return PanelUUID.getURI(ref);
        }

        private static URI getStoryURI(Panel panel) {
            return PanelUUID.getURI(panel);
        }

        private static URI getURI(EObject obj) {
            if (obj == null) {
                return null;
            }
            if (obj.eIsProxy()) {
                return ((InternalEObject)obj).eProxyURI();
            }
            if (obj.eResource() != null) {
                return obj.eResource().getURI();
            }
            return null;
        }
    }
}

